/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.core;

import com.huawei.wsf.util.EmptyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;

class SecureObjectInputStream
extends ObjectInputStream {
    private final List<String> whitelistClassList;

    SecureObjectInputStream(InputStream in, List<String> classList) throws IOException {
        super(in);
        ArrayList<String> dataType = new ArrayList<String>(classList);
        dataType.add("java.lang.Byte");
        dataType.add("java.lang.Short");
        dataType.add("java.lang.Integer");
        dataType.add("java.lang.Long");
        dataType.add("java.lang.Character");
        dataType.add("java.lang.Double");
        dataType.add("java.lang.Float");
        dataType.add("java.lang.Boolean");
        this.whitelistClassList = dataType;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String className = desc.getName();
        if (!EmptyUtils.isEmpty(this.whitelistClassList)) {
            for (String cn : this.whitelistClassList) {
                if (!cn.equalsIgnoreCase(className)) continue;
                return super.resolveClass(desc);
            }
        }
        return null;
    }
}

