/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos;

import com.huawei.wsf.redos.base.DaemonThread;
import com.huawei.wsf.redos.base.ReDosCharSequence;
import com.huawei.wsf.redos.base.ReDosConf;
import com.huawei.wsf.redos.derives.Derive;
import com.huawei.wsf.redos.exception.ExceptionHandler;
import com.huawei.wsf.redos.exception.ReDosException;
import com.huawei.wsf.redos.processor.RegexConvert;
import com.huawei.wsf.redos.regexp.RegExp;
import com.huawei.wsf.redos.regexp.RegexElement;
import com.huawei.wsf.redos.strategy.RepeatStrategy;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReDosManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReDosManager.class);
    private final ExecutorService executorService;
    private ReDosConf config = ReDosConf.getInstance();

    public ReDosManager() {
        this.executorService = Executors.newFixedThreadPool(this.config.getThreadNums(), new DaemonThread());
    }

    public <T> T execute(Callable<T> task, ExceptionHandler handler) {
        Future<T> tFuture = this.executorService.submit(task);
        try {
            return tFuture.get(this.config.getMaxAnalyseTime().intValue(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            LOG.error("execute time out!");
            tFuture.cancel(true);
            throw handler.handle(e);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("execute error!", e);
            tFuture.cancel(true);
            throw handler.handle(e);
        }
    }

    public boolean analyse(String regex) {
        return this.execute(() -> this.isEvilRegExp(regex), new ExceptionHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEvilRegExp(String regexStr) {
        try {
            Pattern pattern = Pattern.compile(regexStr);
            RegexConvert converter = new RegexConvert(regexStr);
            RegExp exp = converter.convert(0);
            if (exp == null) {
                boolean bl = false;
                return bl;
            }
            int counts = 0;
            RepeatStrategy strategy = new RepeatStrategy(this.config.getSampleLength(), this.config.getSampleNums());
            Derive derives = exp.derive(strategy);
            char suffixChar = this.buildSuffixChar(exp);
            for (String str : derives) {
                if (++counts > 10000) {
                    LOG.warn("too many sample!");
                    boolean bl = false;
                    return bl;
                }
                String derivedStr = str + suffixChar;
                try {
                    ReDosCharSequence charSequence = new ReDosCharSequence(derivedStr, derivedStr, pattern.pattern(), this.config.getTimeOut());
                    pattern.matcher(charSequence).matches();
                }
                catch (ReDosException e) {
                    LOG.error("ReDosException count:{}", (Object)counts);
                    boolean bl = true;
                    LOG.debug("Testing:[{}]", (Object)regexStr);
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (PatternSyntaxException e) {
            LOG.error("An error occurred when check the pattern.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            LOG.debug("Testing:[{}]", (Object)regexStr);
        }
    }

    private char buildSuffixChar(RegExp exp) {
        char suffixChar = '\u0000';
        for (char ch = 'a'; ch < '\uffff'; ch = (char)(ch + '\u0001')) {
            RegexElement suffixExp = RegexElement.clone(String.valueOf(ch));
            if (!exp.cross(suffixExp).isEmpty()) continue;
            suffixChar = ch;
            break;
        }
        return suffixChar;
    }
}

