/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.derives;

import com.huawei.wsf.redos.derives.Derive;
import com.huawei.wsf.redos.derives.DeriveUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RepeatDerive
implements Derive {
    private final Derive derive;
    private final int begin;
    private final int end;

    public RepeatDerive(Derive derive, int begin, int end) {
        this.begin = begin;
        this.derive = derive;
        this.end = end;
    }

    @Override
    public Iterator<String> iterator() {
        return new RepeatIter(this.derive, this.begin, this.end);
    }

    @Override
    public int size() {
        return Math.subtractExact(this.end, this.begin);
    }

    @Override
    public boolean isEmpty() {
        return this.begin == 0 && this.end == 0;
    }

    public String toString() {
        return DeriveUtils.toNormalize(this);
    }

    private static class RepeatIter
    implements Iterator<String> {
        private final Derive derive;
        private final int begin;
        private final int end;
        private Iterator<String> elements;
        private int count;

        RepeatIter(Derive derive, int begin, int end) {
            this.begin = begin;
            this.end = end;
            this.derive = derive;
            this.elements = derive.iterator();
            this.count = 0;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String elementStr = this.elements.next();
            StringBuilder sb = new StringBuilder(Math.addExact(this.begin, this.count));
            for (int i = 0; i < this.begin + this.count; ++i) {
                sb.append(elementStr);
            }
            if (!this.elements.hasNext() || sb.length() == 0) {
                this.elements = this.derive.iterator();
                ++this.count;
            }
            return sb.toString();
        }

        @Override
        public boolean hasNext() {
            return this.elements.hasNext() && this.begin + this.count <= this.end;
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

