/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.processor;

import com.huawei.wsf.redos.base.RegexModel;
import com.huawei.wsf.redos.processor.Processor;
import com.huawei.wsf.redos.processor.RegexConvert;
import com.huawei.wsf.redos.regexp.RegExp;
import com.huawei.wsf.redos.regexp.RegexCharClass;
import com.huawei.wsf.redos.regexp.RegexElement;
import com.huawei.wsf.redos.regexp.RegexSeq;

public class BackslashProcessor
extends Processor {
    @Override
    public void handle(RegexConvert processor, RegexModel regexModel, StringBuilder tempStr, Character ch, int level) {
        this.backslash(regexModel, tempStr, processor);
    }

    private void backslash(RegexModel regexModel, StringBuilder tempStr, RegexConvert processor) {
        RegExp rootCopy = processor.getRootNode();
        RegExp currentCopy = processor.getCurNode();
        this.checkRegexModel(regexModel);
        char ch = regexModel.getProcessStr().charAt(1);
        if ("dwsDWS".indexOf(ch) != -1) {
            RegexCharClass chClass = BackslashProcessor.predefinedCharClass(regexModel);
            RegexElement exp = RegexElement.clone(tempStr.toString());
            rootCopy = RegexSeq.clone(rootCopy, currentCopy).toNormalize();
            currentCopy = exp;
            tempStr.setLength(0);
            rootCopy = RegexSeq.clone(rootCopy, currentCopy).toNormalize();
            currentCopy = chClass;
        } else if ("bB".indexOf(ch) != -1) {
            BackslashProcessor.deleteChar(regexModel);
            regexModel.error("Word boundary are not implemented yet!");
        } else if (ch >= '1' && ch <= '9') {
            BackslashProcessor.deleteChar(regexModel);
            regexModel.error("Backreference (\\1 through \\9) are not supported yet!");
        } else {
            tempStr.append(BackslashProcessor.unescapeCurrent(regexModel));
        }
        processor.setRootNode(rootCopy);
        processor.setCurNode(currentCopy);
    }

    private void checkRegexModel(RegexModel regexModel) {
        if (regexModel.getProcessStr().length() < 2) {
            regexModel.error("Premature end of expression after \\");
        }
    }
}

