/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.regexp;

import com.huawei.wsf.redos.regexp.RegExp;
import com.huawei.wsf.redos.regexp.RegexElement;
import com.huawei.wsf.redos.regexp.RegexOptional;
import com.huawei.wsf.redos.regexp.RegexRecursRepeat;
import com.huawei.wsf.redos.regexp.RegexSeq;

public class RegexIterRepeat
extends RegexRecursRepeat {
    public RegexIterRepeat(RegExp pattern, int begin, int end) {
        super(pattern, begin, end);
        this.substitution = this.substitute(pattern, begin, end);
    }

    public static RegexIterRepeat clone(RegExp regExp, int end) {
        return new RegexIterRepeat(regExp, end, end);
    }

    public static RegexIterRepeat clone(RegExp pattern, int begin, int end) {
        return new RegexIterRepeat(pattern, begin, end);
    }

    private RegExp optionalSeq(RegExp pattern, int times) {
        RegExp regExp = RegexElement.EMPTY;
        for (int i = 0; i < times; ++i) {
            regExp = RegexSeq.clone(regExp, RegexOptional.clone(pattern));
        }
        return regExp;
    }

    private RegExp substitute(RegExp regExp, int begin, int end) {
        int repeatTimes = Math.min(end, MAX_REPETITION);
        RegExp newExp = regExp.toNormalize();
        if (repeatTimes < begin) {
            throw new IllegalArgumentException();
        }
        if (repeatTimes == begin) {
            return RegexIterRepeat.seq(newExp, begin);
        }
        return RegexSeq.clone(RegexIterRepeat.seq(newExp, begin), this.optionalSeq(newExp, repeatTimes - begin)).toNormalize();
    }
}

