/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.regexp;

import com.huawei.wsf.redos.base.ReDosConf;
import com.huawei.wsf.redos.derives.Derive;
import com.huawei.wsf.redos.regexp.RegExp;
import com.huawei.wsf.redos.regexp.RegexElement;
import com.huawei.wsf.redos.regexp.RegexSeq;
import com.huawei.wsf.redos.strategy.Strategy;
import java.util.Locale;
import java.util.Set;

public class RegexRecursRepeat
implements RegExp {
    protected static final int MAX_REPETITION = ReDosConf.getInstance().getRepetitionSize();
    private final RegExp regExp;
    private final int begin;
    private final int end;
    protected RegExp substitution;

    public RegexRecursRepeat(RegExp regExp, int begin, int end) {
        this.regExp = regExp;
        this.begin = begin;
        this.end = end;
    }

    public static RegexRecursRepeat clone(RegExp exp, int size) {
        return new RegexRecursRepeat(exp, size, size);
    }

    public static RegexRecursRepeat clone(RegExp exp, int begin, int end) {
        return new RegexRecursRepeat(exp, begin, end);
    }

    protected static RegExp seq(RegExp regExp, int times) {
        RegExp exp = RegexElement.EMPTY;
        for (int i = 0; i < times; ++i) {
            exp = RegexSeq.clone(exp, regExp);
        }
        return exp.toNormalize();
    }

    @Override
    public RegExp cross(RegExp another) {
        return this.substitution.cross(another);
    }

    @Override
    public boolean isEmpty() {
        return this.substitution.isEmpty();
    }

    @Override
    public RegExp.Match matchAt(int index, char ch) {
        return this.substitution.matchAt(index, ch);
    }

    @Override
    public Set<Integer> counts() {
        return this.substitution.counts();
    }

    public String toString() {
        if (this.end == Integer.MAX_VALUE) {
            return String.format(Locale.ENGLISH, "(%s){%d,}", this.regExp, this.begin);
        }
        if (this.begin == this.end) {
            return String.format(Locale.ENGLISH, "(%s){%d}", this.regExp, this.begin);
        }
        return String.format(Locale.ENGLISH, "(%s){%d,%d}", this.regExp, this.begin, this.end);
    }

    @Override
    public RegExp toNormalize() {
        if (this.regExp.isEmpty()) {
            return this.regExp;
        }
        return this;
    }

    @Override
    public Derive derive(Strategy strategy) {
        return strategy.repeat(this.regExp.derive(strategy), this.substitution.derive(strategy), this.begin, this.end);
    }

    public boolean equals(Object other) {
        Object obj = other;
        if (obj instanceof RegExp) {
            obj = ((RegExp)obj).toNormalize();
        }
        if (obj instanceof RegexRecursRepeat) {
            RegexRecursRepeat recursRepeat = (RegexRecursRepeat)obj;
            return this.regExp.equals(recursRepeat.regExp) && this.begin == recursRepeat.begin && this.end == recursRepeat.end;
        }
        return this.substitution.equals(obj);
    }

    public int hashCode() {
        RegExp exp = this.toNormalize();
        if (exp instanceof RegexRecursRepeat) {
            int prime = 31;
            int hashCode = 1;
            hashCode = 31 * hashCode + this.regExp.hashCode();
            hashCode = 31 * hashCode + this.begin;
            hashCode = 31 * hashCode + this.end;
            return hashCode;
        }
        return exp.hashCode();
    }
}

