/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.crypto.CryptoHelper;
import org.owasp.esapi.errors.ConfigurationException;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.util.ByteConversionUtil;

public class KeyDerivationFunction {
    public static final int originalVersion = 20110203;
    public static final int kdfVersion = 20130830;
    private static final long serialVersionUID = 20130830L;
    private static final Logger logger = ESAPI.getLogger("KeyDerivationFunction");
    private String prfAlg_ = null;
    private boolean useHistoryLogic = ESAPI.securityConfiguration().isUseHistoryLogic();
    private int version_ = 20130830;
    private String context_ = "";

    public KeyDerivationFunction(PRF_ALGORITHMS prfAlg) {
        this.prfAlg_ = prfAlg.getAlgName();
    }

    public KeyDerivationFunction() {
        String prfName = ESAPI.securityConfiguration().getKDFPseudoRandomFunction();
        if (!KeyDerivationFunction.isValidPRF(prfName)) {
            throw new ConfigurationException("Algorithm name " + prfName + " not a valid algorithm name for property " + "Encryptor.KDF.PRF");
        }
        this.prfAlg_ = prfName;
    }

    public String getPRFAlgName() {
        return this.prfAlg_;
    }

    static int getDefaultPRFSelection() {
        String prfName = ESAPI.securityConfiguration().getKDFPseudoRandomFunction();
        for (PRF_ALGORITHMS prf : PRF_ALGORITHMS.values()) {
            if (!prf.getAlgName().equals(prfName)) continue;
            return prf.getValue();
        }
        throw new ConfigurationException("Algorithm name " + prfName + " not a valid algorithm name for property " + "Encryptor.KDF.PRF");
    }

    public void setVersion(int version) throws IllegalArgumentException {
        CryptoHelper.isValidKDFVersion(version, false, true);
        this.version_ = version;
    }

    public int getVersion() {
        return this.version_;
    }

    public void setContext(String context) {
        if (context == null) {
            throw new IllegalArgumentException("Context may not be null.");
        }
        this.context_ = context;
    }

    public String getContext() {
        return this.context_;
    }

    public SecretKey computeDerivedKey(SecretKey keyDerivationKey, int keySize, String purpose) throws NoSuchAlgorithmException, InvalidKeyException, EncryptionException {
        SecretKeySpec sk;
        byte[] context;
        byte[] label;
        if (keyDerivationKey == null) {
            throw new IllegalArgumentException("Key derivation key cannot be null.");
        }
        if (keySize < 56) {
            throw new IllegalArgumentException("Key has size of " + keySize + ", which is less than minimum of 56-bits.");
        }
        if (keySize % 8 != 0) {
            throw new IllegalArgumentException("Key size (" + keySize + ") must be a even multiple of 8-bits.");
        }
        if (purpose == null || "".equals(purpose)) {
            throw new IllegalArgumentException("Purpose may not be null or empty.");
        }
        int providedKeyLen = 8 * keyDerivationKey.getEncoded().length;
        if (providedKeyLen < keySize) {
            throw new EncryptionException("KeyDerivationFunction.computeDerivedKey() not intended for key stretching: provided key too short (" + providedKeyLen + " bits) to provide " + keySize + " bits.", "Key stretching not supported: Provided key, keyDerivationKey, has insufficient entropy (" + providedKeyLen + " bits) to generate key of requested size of " + keySize + " bits.");
        }
        keySize = KeyDerivationFunction.calcKeySize(keySize);
        byte[] derivedKey = new byte[keySize];
        try {
            label = purpose.getBytes("UTF-8");
            context = this.context_.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EncryptionException("Encryption failure (internal encoding error: UTF-8)", "UTF-8 encoding is NOT supported as a standard byte encoding: " + e.getMessage(), e);
        }
        Mac mac = null;
        if (this.useHistoryLogic) {
            sk = new SecretKeySpec(keyDerivationKey.getEncoded(), "HmacSHA1");
            try {
                mac = Mac.getInstance("HmacSHA1");
                mac.init(sk);
            }
            catch (InvalidKeyException ex) {
                logger.error(Logger.SECURITY_FAILURE, "Created HmacSHA1 Mac but SecretKey sk has alg " + sk.getAlgorithm(), ex);
                throw ex;
            }
        }
        sk = new SecretKeySpec(keyDerivationKey.getEncoded(), this.prfAlg_);
        try {
            mac = Mac.getInstance(this.prfAlg_);
            mac.init(sk);
        }
        catch (InvalidKeyException ex) {
            logger.error(Logger.SECURITY_FAILURE, "Created " + this.prfAlg_ + " Mac but SecretKey sk has alg " + sk.getAlgorithm(), ex);
            throw ex;
        }
        int ctr = 1;
        int totalCopied = 0;
        int destPos = 0;
        int len = 0;
        byte[] tmpKey = null;
        do {
            mac.update(ByteConversionUtil.fromInt(ctr++));
            mac.update(label);
            mac.update((byte)0);
            mac.update(context);
            tmpKey = mac.doFinal(ByteConversionUtil.fromInt(keySize));
            len = tmpKey.length >= keySize ? keySize : Math.min(tmpKey.length, keySize - totalCopied);
            System.arraycopy(tmpKey, 0, derivedKey, destPos, len);
            label = tmpKey;
            destPos += len;
        } while ((totalCopied += tmpKey.length) < keySize);
        for (int i = 0; i < tmpKey.length; ++i) {
            tmpKey[i] = 0;
        }
        tmpKey = null;
        return new SecretKeySpec(derivedKey, keyDerivationKey.getAlgorithm());
    }

    public static boolean isValidPRF(String prfAlgName) {
        for (PRF_ALGORITHMS prf : PRF_ALGORITHMS.values()) {
            if (!prf.getAlgName().equals(prfAlgName)) continue;
            return true;
        }
        return false;
    }

    public static PRF_ALGORITHMS convertNameToPRF(String prfAlgName) {
        for (PRF_ALGORITHMS prf : PRF_ALGORITHMS.values()) {
            if (!prf.getAlgName().equals(prfAlgName)) continue;
            return prf;
        }
        throw new IllegalArgumentException("Algorithm name " + prfAlgName + " not a valid PRF algorithm name for the ESAPI KDF.");
    }

    public static PRF_ALGORITHMS convertIntToPRF(int selection) {
        for (PRF_ALGORITHMS prf : PRF_ALGORITHMS.values()) {
            if (prf.getValue() != selection) continue;
            return prf;
        }
        throw new IllegalArgumentException("No KDF PRF algorithm found for value name " + selection);
    }

    private static int calcKeySize(int ks) {
        if (ks <= 0) {
            throw new IllegalArgumentException("Key size must be > 0 bits.");
        }
        int numBytes = 0;
        int n = ks / 8;
        int rem = ks % 8;
        numBytes = rem == 0 ? n : n + 1;
        return numBytes;
    }

    public static final void main(String[] args) {
        System.out.println("Supported pseudo-random functions for KDF (version: 20130830)");
        System.out.println("Enum Name\tAlgorithm\t# bits");
        for (PRF_ALGORITHMS prf : PRF_ALGORITHMS.values()) {
            System.out.println((Object)((Object)prf) + "\t" + prf.getAlgName() + "\t" + prf.getBits());
        }
    }

    public static enum PRF_ALGORITHMS {
        HmacSHA1(0, 160, "HmacSHA1"),
        HmacSHA256(1, 256, "HmacSHA256"),
        HmacSHA384(2, 384, "HmacSHA384"),
        HmacSHA512(3, 512, "HmacSHA512");

        private final byte value;
        private final short bits;
        private final String algName;

        private PRF_ALGORITHMS(int value, int bits, String algName) {
            this.value = (byte)value;
            this.bits = (short)bits;
            this.algName = algName;
        }

        public byte getValue() {
            return this.value;
        }

        public short getBits() {
            return this.bits;
        }

        public String getAlgName() {
            return this.algName;
        }
    }
}

