/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.reference.crypto.ReferenceEncryptedProperties;

public class EncryptedPropertiesUtils {
    private static final Logger logger = ESAPI.getLogger("EncryptedPropertiesUtils");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String inFile, Boolean inFileEncrypted) throws IOException {
        ReferenceEncryptedProperties props;
        if (inFileEncrypted == null) {
            inFileEncrypted = true;
        }
        if (inFile != null) {
            File f = new File(inFile);
            if (!f.exists()) {
                props = new ReferenceEncryptedProperties();
            } else {
                Properties inProperties = inFileEncrypted != false ? new ReferenceEncryptedProperties() : new Properties();
                FileInputStream in = null;
                try {
                    in = new FileInputStream(f);
                    inProperties.load(in);
                }
                finally {
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (Exception e) {
                        logger.error(Logger.EVENT_FAILURE, e.getMessage());
                    }
                }
                props = new ReferenceEncryptedProperties(inProperties);
            }
        } else {
            props = new ReferenceEncryptedProperties();
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(String outFile, Properties props, String message) throws Exception {
        OutputStream out = null;
        try {
            out = new FileOutputStream(new File(outFile));
            props.store(out, message);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Object addProperty(Properties props, String key, String value) {
        if (props != null && key != null && key.length() > 0 && value != null && value.length() > 0) {
            return props.setProperty(key, value);
        }
        return null;
    }
}

