/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.crypto;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.EncryptedProperties;
import org.owasp.esapi.Logger;
import org.owasp.esapi.crypto.CipherText;
import org.owasp.esapi.crypto.PlainText;
import org.owasp.esapi.errors.EncryptionRuntimeException;

public class ReferenceEncryptedProperties
extends Properties
implements EncryptedProperties {
    private static final long serialVersionUID = 20120718L;
    private final Logger logger = ESAPI.getLogger(this.getClass());
    private static final String[] GET_ERROR_MESSAGES = new String[]{": failed decoding from base64", ": failed to deserialize properly", ": failed to decrypt properly"};
    private static final String[] SET_ERROR_MESSAGES = new String[]{": failed to encrypt properly", ": failed to serialize correctly", ": failed to base64-encode properly", ": failed to set base64-encoded value as property. Illegal key name?"};

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    public synchronized boolean equals(Object o) {
        return super.equals(o);
    }

    public ReferenceEncryptedProperties() {
    }

    public ReferenceEncryptedProperties(Properties defaults) {
        for (Object oKey : defaults.keySet()) {
            String key = oKey instanceof String ? (String)oKey : oKey.toString();
            String value = defaults.getProperty(key);
            this.setProperty(key, value);
        }
    }

    @Override
    public synchronized String getProperty(String key) throws EncryptionRuntimeException {
        int progressMark = 0;
        try {
            String encryptedValue = super.getProperty(key);
            if (encryptedValue == null) {
                return null;
            }
            progressMark = 0;
            byte[] serializedCiphertext = ESAPI.encoder().decodeFromBase64(encryptedValue);
            ++progressMark;
            CipherText restoredCipherText = CipherText.fromPortableSerializedBytes(serializedCiphertext);
            ++progressMark;
            PlainText plaintext = ESAPI.encryptor().decrypt(restoredCipherText);
            return plaintext.toString();
        }
        catch (Exception e) {
            throw new EncryptionRuntimeException("Property retrieval failure", "Couldn't retrieve encrypted property for property " + key + GET_ERROR_MESSAGES[progressMark], e);
        }
    }

    @Override
    public synchronized String getProperty(String key, String defaultValue) throws EncryptionRuntimeException {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public final synchronized String setProperty(String key, String value) throws EncryptionRuntimeException {
        int progressMark = 0;
        try {
            if (key == null) {
                throw new NullPointerException("Property name may not be null.");
            }
            if (value == null) {
                throw new NullPointerException("Property value may not be null.");
            }
            PlainText pt = new PlainText(value);
            CipherText ct = ESAPI.encryptor().encrypt(pt);
            ++progressMark;
            byte[] serializedCiphertext = ct.asPortableSerializedByteArray();
            ++progressMark;
            String b64str = ESAPI.encoder().encodeForBase64(serializedCiphertext, false);
            ++progressMark;
            return (String)super.put(key, b64str);
        }
        catch (Exception e) {
            throw new EncryptionRuntimeException("Property setting failure", "Couldn't set encrypted property " + key + SET_ERROR_MESSAGES[progressMark], e);
        }
    }

    @Override
    public void load(InputStream in) throws IOException {
        super.load(in);
        this.logger.trace(Logger.SECURITY_SUCCESS, "Encrypted properties loaded successfully");
    }

    @Override
    public void load(Reader in) throws IOException {
        if (in == null) {
            return;
        }
        char[] cbuf = new char[65536];
        BufferedReader buff = new BufferedReader(in);
        StringBuilder contents = new StringBuilder();
        int read_this_time = 0;
        while (read_this_time != -1) {
            read_this_time = buff.read(cbuf, 0, 65536);
            if (read_this_time <= 0) continue;
            contents.append(cbuf, 0, read_this_time);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(contents.toString().getBytes());
        super.load(is);
    }

    @Override
    public void list(PrintStream out) {
        throw new UnsupportedOperationException("This method has been removed for security.");
    }

    @Override
    public void list(PrintWriter out) {
        throw new UnsupportedOperationException("This method has been removed for security.");
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException("This method has been removed for security.");
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException("This method has been removed for security.");
    }

    @Override
    public Enumeration elements() {
        throw new UnsupportedOperationException("This method has been removed for security.");
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return super.put(key, value);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode());
    }
}

