/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.engine;

import com.huawei.security.checkengine.bean.BadRequestDefinition;
import com.huawei.security.checkengine.engine.AbstractEngine;
import com.huawei.security.checkengine.exception.CheckEngineException;
import com.huawei.security.checkengine.exception.MultipartCheckException;
import com.huawei.security.checkengine.exception.NotCheckContentException;
import com.huawei.security.checkengine.exception.RuleLoadingException;
import com.huawei.security.checkengine.filecontent.FileContentCheckInterface;
import com.huawei.security.checkengine.filecontent.GzipContentCheck;
import com.huawei.security.checkengine.filecontent.RarContentCheck;
import com.huawei.security.checkengine.filecontent.TarBzContentCheck;
import com.huawei.security.checkengine.filecontent.TarContentCheck;
import com.huawei.security.checkengine.filecontent.TargzContentCheck;
import com.huawei.security.checkengine.filecontent.XMLContentCheck;
import com.huawei.security.checkengine.filecontent.ZipContentCheck;
import com.huawei.security.checkengine.util.CheckTypeEnum;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileContentCheckAttack
extends AbstractEngine {
    private static final Logger LOG = LoggerFactory.getLogger(FileContentCheckAttack.class);
    private static final Map<CheckTypeEnum, FileContentCheckInterface> CONTENT_CHECK_MAP = new HashMap<CheckTypeEnum, FileContentCheckInterface>();
    private static ZipContentCheck zipContentCheck = new ZipContentCheck();
    private static XMLContentCheck xmlContentCheck = new XMLContentCheck();
    private static RarContentCheck rarContentCheck = new RarContentCheck();
    private static TarContentCheck tarContentCheck = new TarContentCheck();
    private static TargzContentCheck targzContentCheck = new TargzContentCheck();
    private static TarBzContentCheck tarBzContentCheck = new TarBzContentCheck();
    private static GzipContentCheck gzipContentCheck = new GzipContentCheck();
    private CheckTypeEnum[] checkType;

    @Override
    public void init(CheckTypeEnum[] checkType) throws RuleLoadingException {
        if (checkType != null) {
            this.checkType = new CheckTypeEnum[checkType.length];
            System.arraycopy(checkType, 0, this.checkType, 0, checkType.length);
        }
        this.loadRule();
    }

    @Override
    public void check(Object input, CheckTypeEnum[] checkType, Object closeInputStream, Properties overrideProps) throws CheckEngineException {
        CheckTypeEnum[] badRequestCheckType;
        if (!(input instanceof InputStream)) {
            LOG.error("[WSF-CheckEngine] Validate file content is null.");
            throw new NotCheckContentException("Validate file content is null.");
        }
        InputStream inputStream = (InputStream)input;
        if (checkType != null) {
            badRequestCheckType = checkType;
        } else if (this.checkType != null) {
            badRequestCheckType = this.checkType;
        } else {
            LOG.error("[WSF-CheckEngine] Missing check type for checking file content.");
            throw new NotCheckContentException("Set check type is error.");
        }
        Boolean isCloseInputStream = null;
        if (!(closeInputStream instanceof Boolean)) {
            throw new MultipartCheckException("CloseInputStream failed to downcast.");
        }
        isCloseInputStream = (Boolean)closeInputStream;
        for (CheckTypeEnum checkTypeEnum : badRequestCheckType) {
            this.checkContentByType(inputStream, isCloseInputStream, overrideProps, checkTypeEnum);
        }
    }

    private void checkContentByType(InputStream inputStream, Boolean isCloseInputStream, Properties overrideProps, CheckTypeEnum checkTypeEnum) throws CheckEngineException {
        FileContentCheckInterface fileContentCheckInterface = CONTENT_CHECK_MAP.get((Object)checkTypeEnum);
        if (fileContentCheckInterface == null) {
            LOG.error("[WSF-CheckEngine] Do not support check type, check type is {}.", (Object)checkTypeEnum.getCheckTypeName());
            if (isCloseInputStream.booleanValue()) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error("[WSF-CheckEngine] Failed to close the input stream.");
                    throw new NotCheckContentException("Failed to close the input stream.", e);
                }
            }
            throw new NotCheckContentException("[WSF-CheckEngine] Can't check inputStream content, please set correct check type.");
        }
        LOG.debug("[WSF-CheckEngine] 1B_ZIP_Oversized_Uploads.ce rule begin check, file type is {}.", (Object)checkTypeEnum.getCheckTypeName());
        BadRequestDefinition zipDefinition = this.getDefinition("1B_ZIP_Oversized_Uploads.ce");
        fileContentCheckInterface.checkFileContent(inputStream, zipDefinition, isCloseInputStream, overrideProps);
    }

    static {
        CONTENT_CHECK_MAP.put(CheckTypeEnum.ZIP, zipContentCheck);
        CONTENT_CHECK_MAP.put(CheckTypeEnum.DOCX, zipContentCheck);
        CONTENT_CHECK_MAP.put(CheckTypeEnum.XLSX, zipContentCheck);
        CONTENT_CHECK_MAP.put(CheckTypeEnum.XML, xmlContentCheck);
        CONTENT_CHECK_MAP.put(CheckTypeEnum.RAR, rarContentCheck);
        CONTENT_CHECK_MAP.put(CheckTypeEnum.TAR, tarContentCheck);
        CONTENT_CHECK_MAP.put(CheckTypeEnum.TARGZ, targzContentCheck);
        CONTENT_CHECK_MAP.put(CheckTypeEnum.TARBZ2, tarBzContentCheck);
        CONTENT_CHECK_MAP.put(CheckTypeEnum.GZ, gzipContentCheck);
    }
}

