/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.filecontent;

import com.huawei.security.checkengine.bean.BadRequestDefinition;
import com.huawei.security.checkengine.exception.MultipartCheckException;
import com.huawei.security.checkengine.exception.NotCheckContentException;
import com.huawei.security.checkengine.filecontent.FileContentCheckInterface;
import com.huawei.security.checkengine.util.FileContentCheckUtil;
import com.huawei.security.checkengine.util.ZipCheckParameter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargzContentCheck
implements FileContentCheckInterface {
    private static final Logger LOG = LoggerFactory.getLogger(TargzContentCheck.class);
    private static final String START_PATH = FileContentCheckUtil.getStartPath();
    private static byte[] dataBuffer = new byte[512];
    private static final Object LOCK = new Object();

    /*
     * Exception decompiling
     */
    @Override
    public void checkFileContent(InputStream fileContent, BadRequestDefinition checkRule, boolean shouldCloseStream, Properties overrideProps) throws MultipartCheckException, NotCheckContentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean parseAndCheckInputStream(BadRequestDefinition checkRule, Properties overrideProps, TarArchiveInputStream input) throws MultipartCheckException, IOException {
        boolean isTargz = false;
        TarArchiveEntry entry = null;
        ZipCheckParameter checkParameter = new ZipCheckParameter(overrideProps, checkRule);
        int fileNum = 0;
        long totalSize = 0L;
        while ((entry = input.getNextTarEntry()) != null) {
            isTargz = true;
            boolean isDir = entry.isDirectory();
            FileContentCheckUtil.checkFileName(entry.getName(), isDir, START_PATH, true, checkParameter);
            if (isDir) continue;
            this.checkFileNum(++fileNum, checkParameter);
            totalSize = this.checkFileTotalSize(checkParameter.getMaxSize(), totalSize, input);
        }
        return isTargz;
    }

    private void closeResource(InputStream fileContent, boolean shouldCloseStream) {
        if (shouldCloseStream) {
            try {
                fileContent.close();
            }
            catch (IOException e) {
                LOG.error("[WSF-CheckEngine] Failed to close the input stream.");
            }
        }
    }

    private void checkFileNum(int fileNum, ZipCheckParameter checkParameter) throws MultipartCheckException {
        if (fileNum > checkParameter.getMaxFileNum()) {
            LOG.error("[WSF-CheckEngine] Too many files to untargz, the max file number is " + checkParameter.getMaxFileNum());
            throw new MultipartCheckException("Checking tar.gz file numbers failed.");
        }
    }

    private long checkFileTotalSize(long maxSize, long totalSize, TarArchiveInputStream input) throws MultipartCheckException, IOException {
        long res = totalSize;
        int count = -1;
        while ((count = input.read(dataBuffer, 0, 512)) != -1) {
            if ((res += (long)count) <= maxSize) continue;
            LOG.error("[WSF-CheckEngine] File being untared is too big, the max size is: " + maxSize);
            throw new MultipartCheckException("Checking tar.gz file size failed.");
        }
        return res;
    }
}

