/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.checkengine.util;

import com.huawei.security.checkengine.exception.MultipartCheckException;
import com.huawei.security.checkengine.util.EmptyUtils;
import com.huawei.security.checkengine.util.LogUtils;
import com.huawei.security.checkengine.util.ZipCheckParameter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileContentCheckUtil {
    public static final String VIRTURL_TARGET_PATH_FOR_CHECK_FILENAME = "/virtual/target/path/for/check/filename";
    private static final String NO_TEMPORARY_PATH_STR = "[WSF-CheckEngine] Failed to get temporary dir path.";
    private static final String TEMP_DIR1 = "temp";
    private static final String TEMP_DIR2 = "Temp";
    private static final String TMP_DIR1 = "tmp";
    private static final String TMP_DIR2 = "Tmp";
    private static final int BUFFER = 512;
    private static final Logger LOG = LoggerFactory.getLogger(FileContentCheckUtil.class);
    private static AtomicInteger counter = new AtomicInteger(0);
    private static String validateTempPath;

    private FileContentCheckUtil() {
    }

    public static String checkFileName(String entryName, String targetDir) throws IOException, MultipartCheckException {
        return FileContentCheckUtil.checkFileName(entryName, false, targetDir, true, new ZipCheckParameter());
    }

    public static String checkFileName(String entryName, boolean isDir, String targetDir, boolean doTargetCheck, ZipCheckParameter checkParameter) throws IOException, MultipartCheckException {
        String entryNameCopy = entryName.replace('\\', '/');
        String[] directoryNames = entryNameCopy.split("/");
        String targetPath = FileContentCheckUtil.getFile(targetDir).getCanonicalPath();
        String filePath = FileContentCheckUtil.getFile(targetDir, entryName).getCanonicalPath();
        FileContentCheckUtil.checkPathLimit(targetPath, filePath, doTargetCheck);
        FileContentCheckUtil.checkPathLength(checkParameter.getMaxPathLen(), entryNameCopy);
        FileContentCheckUtil.checkPathDepth(checkParameter.getMaxPathDepth(), entryNameCopy);
        FileContentCheckUtil.checkDirectoryNameLength(checkParameter.getMaxFileNameLen(), directoryNames);
        FileContentCheckUtil.checkNameValue(checkParameter.getValidFolderName(), checkParameter.getValidFileName(), directoryNames, isDir);
        return filePath;
    }

    public static int countMatches(String str, String sub) {
        if (EmptyUtils.isEmpty(str) || !EmptyUtils.hasLength(sub)) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((pos = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos += sub.length();
        }
        return count;
    }

    public static void deleteFile(String fileName) {
        File file = FileContentCheckUtil.getFile(fileName);
        if (file.exists() && file.isFile() && !file.delete()) {
            LOG.error("[WSF-CheckEngine] Failed to delete temp file.");
        }
    }

    public static String getStartPath() {
        return VIRTURL_TARGET_PATH_FOR_CHECK_FILENAME;
    }

    public static String getValidateTempPath() throws MultipartCheckException {
        if (validateTempPath == null) {
            String temp = System.getProperty("java.io.tmpdir");
            if (EmptyUtils.isEmpty(temp)) {
                LOG.error("[WSF-CheckEngine] Failed to get temporary dir path.; java.io.tmpdir is not defined, or empty.");
                throw new MultipartCheckException(NO_TEMPORARY_PATH_STR);
            }
            File file = FileContentCheckUtil.getFile(temp);
            try {
                validateTempPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                validateTempPath = null;
                LOG.error("[WSF-CheckEngine] Failed to get temporary dir path.; java.io.tmpdir may set with wrong value.");
                throw new MultipartCheckException(NO_TEMPORARY_PATH_STR, e);
            }
            if (!file.isDirectory()) {
                validateTempPath = null;
                LOG.error("[WSF-CheckEngine] Failed to get temporary dir path., make sure java.io.tmpdir is a directory.");
                throw new MultipartCheckException(NO_TEMPORARY_PATH_STR);
            }
            String tempDirCheck = System.getProperty("tempDirCheck");
            if (!("true".equals(tempDirCheck) || validateTempPath.endsWith(TEMP_DIR1) || validateTempPath.endsWith(TEMP_DIR2) || validateTempPath.endsWith(TMP_DIR1) || validateTempPath.endsWith(TMP_DIR2))) {
                validateTempPath = null;
                LOG.error("[WSF-CheckEngine] Failed to get temporary dir path., make sure java.io.tmpdir specified temp directory end with tmp|Tmp|temp|Temp name.");
                throw new MultipartCheckException(NO_TEMPORARY_PATH_STR);
            }
        }
        return validateTempPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String saveAsFile(InputStream fileContent) throws MultipartCheckException {
        String path;
        File tmpFile = FileContentCheckUtil.getFile(FileContentCheckUtil.getValidateTempPath() + File.separator + "tmp_" + System.currentTimeMillis() + "_" + counter.getAndIncrement());
        try {
            path = tmpFile.getCanonicalPath();
        }
        catch (IOException ex) {
            LOG.error("[WSF-CheckEngine] Failed to get temp file CanonicalPath.");
            throw new MultipartCheckException("Failed to get temp file CanonicalPath", ex);
        }
        try (FileOutputStream fos = new FileOutputStream(tmpFile);){
            int index;
            byte[] data = new byte[512];
            while ((index = fileContent.read(data)) != -1) {
                fos.write(data, 0, index);
            }
            String string = path;
            return string;
        }
        catch (IOException e) {
            if ("true".equalsIgnoreCase(System.getProperty("cleanTempFileSwitch"))) {
                FileContentCheckUtil.deleteFile(path);
            }
            LOG.error("[WSF-CheckEngine] Failed to save the input stream.");
            throw new MultipartCheckException("Failed to save the input stream.", e);
        }
    }

    private static void checkPathLimit(String targetPath, String filePath, boolean doTargetCheck) throws MultipartCheckException {
        if (doTargetCheck && !filePath.startsWith(targetPath)) {
            LOG.error("[WSF-CheckEngine] File is outside extraction target directory.");
            throw new MultipartCheckException("Checking file content failed.");
        }
    }

    private static void checkPathLength(int maxPathLen, String entryName) throws MultipartCheckException {
        if (maxPathLen > 0 && entryName.length() > maxPathLen) {
            LOG.error("[WSF-CheckEngine] File path is too long. The max path length is: {}.", (Object)maxPathLen);
            throw new MultipartCheckException("Checking file content failed.");
        }
    }

    private static void checkPathDepth(int maxPathDepth, String entryName) throws MultipartCheckException {
        if (maxPathDepth > 0 && FileContentCheckUtil.countMatches(entryName, "/") > maxPathDepth) {
            LOG.error("[WSF-CheckEngine] File path is too deep. The max path depth is: {}.", (Object)maxPathDepth);
            throw new MultipartCheckException("Checking file content failed.");
        }
    }

    private static void checkDirectoryNameLength(int maxFileNameLen, String[] directoryNames) throws MultipartCheckException {
        if (maxFileNameLen <= 0) {
            return;
        }
        for (String directoryName : directoryNames) {
            if (directoryName.length() <= maxFileNameLen) continue;
            LOG.error("[WSF-CheckEngine] File/Folder name is too long. The max length for file/folder name is: {}.", (Object)maxFileNameLen);
            throw new MultipartCheckException("Checking file content failed.");
        }
    }

    private static void checkNameValue(Pattern zippedValidFolderName, Pattern zippedValidFileName, String[] directoryNames, boolean isDir) throws MultipartCheckException {
        String fileName = directoryNames[directoryNames.length - 1];
        if (!isDir && zippedValidFileName != null && !zippedValidFileName.matcher(fileName).matches()) {
            LOG.error("[WSF-CheckEngine] File name is not match. The valid file name pattern is: {}.", (Object)LogUtils.cleanLog(zippedValidFileName.pattern()));
            throw new MultipartCheckException("Checking file content failed.");
        }
        if (isDir && zippedValidFolderName != null && !zippedValidFolderName.matcher(fileName).matches()) {
            LOG.error("[WSF-CheckEngine] Folder name is not matched. The valid folder name pattern is: {}.", (Object)LogUtils.cleanLog(zippedValidFolderName.pattern()));
            throw new MultipartCheckException("Checking file content failed.");
        }
    }

    public static File getFile(String fileName) {
        FileContentCheckUtil.checkFileName(fileName);
        return new File(fileName);
    }

    public static File getFile(String firstFileName, String secondFileName) {
        FileContentCheckUtil.checkFileName(firstFileName);
        FileContentCheckUtil.checkFileName(secondFileName);
        return new File(new File(firstFileName), secondFileName);
    }

    private static void checkFileName(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            throw new NullPointerException("filename is null or filename is empty, please check your input.");
        }
    }
}

