/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator;

import com.huawei.security.validator.bean.Parameter;
import com.huawei.security.validator.bean.ValidateFileConfig;
import com.huawei.security.validator.bean.ValidateRuleBean;
import com.huawei.security.validator.config.FileCache;
import com.huawei.security.validator.exception.ParamValueValidateFailException;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.manager.AbstractProcessValidate;
import com.huawei.security.validator.manager.FormProcessValidate;
import com.huawei.security.validator.manager.JsonProcessValidate;
import com.huawei.security.validator.manager.QueryStringProcessValidate;
import com.huawei.security.validator.manager.UrlPathProcessValidate;
import com.huawei.security.validator.manager.XmlProcessValidate;
import com.huawei.security.validator.requestmapping.RequestSpecificMappingInfo;
import com.huawei.security.validator.requestmapping.RequestSpecificMappingInfoComparator;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.PublicData;
import com.huawei.security.validator.web.HttpParameter;
import com.huawei.security.validator.web.JsonParameter;
import com.huawei.security.validator.web.QueryStringParameter;
import com.huawei.security.validator.web.XmlParameter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

public class ValidatorManager {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private static final Integer SINGLE_RULE_SIZE = 1;
    private Map<RequestSpecificMappingInfo, ValidateRuleBean> catchMap = FileCache.getInstance().getValidateParam();
    private Map<String, Set<String>> validateRuleSizeMap = FileCache.getInstance().getValidateRuleSize();
    private AntPathMatcher matcher = new AntPathMatcher();

    public void validatorParam(Parameter paramObject, ValidateRuleBean validateObject, PublicData publicData) throws ParamValueValidateFailException, ParseRequestDataException, ValidateException {
        AbstractProcessValidate processValidate = null;
        if (paramObject instanceof HttpParameter) {
            processValidate = new FormProcessValidate(validateObject, publicData);
        } else if (paramObject instanceof JsonParameter) {
            processValidate = new JsonProcessValidate(validateObject, publicData);
            this.validateQueryString(publicData, validateObject);
        } else if (paramObject instanceof XmlParameter) {
            processValidate = new XmlProcessValidate(validateObject, publicData);
            this.validateQueryString(publicData, validateObject);
        } else if (paramObject instanceof QueryStringParameter) {
            processValidate = new QueryStringProcessValidate(validateObject, publicData);
        } else {
            LOG.error("[WSF-ParamValidate] Not support the data type.");
            throw new ValidateException("Not support the data type.");
        }
        if (publicData.getUrlPathParameter() != null) {
            UrlPathProcessValidate urlPathProcess = new UrlPathProcessValidate(validateObject, publicData);
            urlPathProcess.validatorParam(publicData.getUrlPathParameter());
            LOG.info("[WSF-ParamValidate] End validate url path parameter.");
        }
        ((AbstractProcessValidate)processValidate).validatorParam(paramObject);
    }

    public ValidateRuleBean getValidateObject(String uri, String method, String contentType, ValidateFileConfig fileConfig, boolean contentTypeSwitch) {
        return this.getOptionalValidateRuleBean(uri, method, contentType, fileConfig, contentTypeSwitch).orElse(null);
    }

    private Optional<ValidateRuleBean> getOptionalValidateRuleBean(String uri, String method, String contentType, ValidateFileConfig fileConfig, boolean contentTypeSwitch) {
        RequestSpecificMappingInfo info2;
        LOG.debug("[WSF-ParamValidate] Request method {}, request uri : {}.", (Object)LogUtils.cleanLog(method), (Object)LogUtils.cleanLog(uri));
        ArrayList<RequestSpecificMappingInfo> mappingInfoList = new ArrayList<RequestSpecificMappingInfo>(this.catchMap.size());
        int ruleSize = 0;
        for (Map.Entry<String, Set<String>> entry : this.validateRuleSizeMap.entrySet()) {
            if (!this.matcher.match((String)entry.getKey(), uri)) continue;
            ruleSize = this.validateRuleSizeMap.get(entry.getKey()).size();
            break;
        }
        for (RequestSpecificMappingInfo info2 : this.catchMap.keySet()) {
            boolean isSpecialRequest;
            boolean isLoad = false;
            boolean bl = isSpecialRequest = StringUtils.isEmpty(contentType) || this.isSpecialDataPattern(info2.getDataPattern()) || ruleSize <= SINGLE_RULE_SIZE;
            if (isSpecialRequest) {
                isLoad = info2.matchesRequestMethod(method) && this.matcher.match(info2.getPatterns()[0], uri);
            } else if (ruleSize > SINGLE_RULE_SIZE) {
                isLoad = info2.matchesRequestMethod(method) && this.matcher.match(info2.getPatterns()[0], uri) && (contentTypeSwitch || this.isContentTypeInWhiteList(contentType, info2.getDataPattern(), fileConfig));
            } else {
                LOG.info("[WSF-ParamValidate] WSF configuration is not match with the request.");
            }
            if (!isLoad) continue;
            LOG.debug("[WSF-ParamValidate] Find one match validate rule config uri: {}.", (Object)info2.getPatterns()[0]);
            mappingInfoList.add(info2);
        }
        if (mappingInfoList.isEmpty()) {
            LOG.debug("[WSF-ParamValidate] Can't find matched config validate rule.");
            return Optional.empty();
        }
        Comparator<String> patternComparator = this.matcher.getPatternComparator(uri);
        mappingInfoList.sort(new RequestSpecificMappingInfoComparator(patternComparator));
        info2 = (RequestSpecificMappingInfo)mappingInfoList.get(0);
        LOG.debug("[WSF-ParamValidate] Get config validate rule, matching uri: {}.", (Object)LogUtils.cleanLog(info2.toString()));
        return Optional.ofNullable(this.catchMap.get(info2));
    }

    private boolean isContentTypeInWhiteList(String contentType, String dataPattern, ValidateFileConfig fileConfig) {
        String[] contentTypes;
        LOG.info("[WSF-ParamValidate] Check whether contentType in white list or not, dataPattern is \"{}\"", (Object)LogUtils.cleanLog((String)dataPattern));
        switch (dataPattern) {
            case "xml": {
                contentTypes = fileConfig.getXmlContentTypeWhiteList().split("#;#");
                break;
            }
            case "json": {
                contentTypes = fileConfig.getJsonContentTypeWhiteList().split("#;#");
                break;
            }
            case "form": {
                contentTypes = fileConfig.getFormContentTypeWhiteList().split("#;#");
                break;
            }
            default: {
                LOG.error("[WSF-ParamValidate] Error dataPattern.");
                return false;
            }
        }
        for (String item : contentTypes) {
            if (!contentType.toLowerCase(Locale.ROOT).startsWith(item.toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        LOG.error("[WSF-ParamValidate] ContentTypes is empty or content type does not in white list");
        return false;
    }

    private boolean isSpecialDataPattern(String dataPattern) {
        return "json_conversion_form".equalsIgnoreCase(dataPattern) || "xml_conversion_form".equalsIgnoreCase(dataPattern);
    }

    private void validateQueryString(PublicData publicData, ValidateRuleBean validateObject) throws ParamValueValidateFailException, ValidateException {
        QueryStringProcessValidate queryStringProcess = new QueryStringProcessValidate(validateObject, publicData);
        queryStringProcess.validatorParam(publicData.getQueryStringParameter());
    }
}

