/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.config;

import com.huawei.security.validator.config.AbstractRuleFileLoad;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.Resources;
import com.huawei.security.validator.util.WSFSaxRead;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.slf4j.Logger;

public class ClassLoadJarConfigFile
extends AbstractRuleFileLoad {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private static final int VALIDATE_PARAM_MAP_SIZE = 128;
    private static final int SUB_STRING_INDEX = 2;
    private static final String DEFAULT_PATH = "validate";

    @Override
    public void loadConfigFile() throws ValidateException {
        if (EmptyUtils.isEmpty(this.path)) {
            this.path = DEFAULT_PATH;
            LOG.info("[WSF-ParamValidate] Config the path is null, default path is {}.", (Object)DEFAULT_PATH);
        }
        String jarPath = this.path;
        try {
            String urlStr = Resources.getResourceURL(this.path).toString();
            jarPath = urlStr.substring(0, urlStr.indexOf("!/") + 2);
            URL jarUrl = new URL(jarPath);
            this.validateParamMap = new HashMap(128);
            this.validateRuleSizeMap = new HashMap(128);
            this.parseCombinedValidators(jarUrl);
            this.parseCommonConfig(jarUrl);
            this.parseValidateTemplate(jarUrl);
            this.parseValidateRule(jarUrl);
        }
        catch (MalformedURLException e) {
            LOG.info("[WSF-ParamValidate] Error jar path.");
            throw new ValidateException("Error jar path");
        }
        catch (IOException e) {
            LOG.info("[WSF-ParamValidate] Could not find the config JarFile.");
            throw new ValidateException("Could not find the config JarFile");
        }
    }

    private void parseCommonConfig(URL jarUrl) throws ValidateException {
        try (JarFile jarFile = this.readJarFromUrl(jarUrl);){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            WSFSaxRead wsfReader = new WSFSaxRead();
            while (jarEntries.hasMoreElements()) {
                String entryName;
                JarEntry entry = jarEntries.nextElement();
                if (entry.isDirectory() || !(entryName = entry.getName()).endsWith("validate-common-config.xml")) continue;
                LOG.debug("[WSF-ParamValidate] Begin parse validate-common-config.xml.");
                URL entryUrl = Resources.getResourceURL(entryName);
                Document document = wsfReader.read(entryUrl);
                this.parseCommonConfigXml(document, "classpath:" + entryName);
                LOG.debug("[WSF-ParamValidate] End parse validate-common-config.xml.");
            }
        }
        catch (IOException | DocumentException ex) {
            throw new ValidateException("Can't find or parse validate-common-config.xml in jar.", ex);
        }
    }

    private void parseValidateTemplate(URL jarUrl) throws ValidateException {
        try (JarFile jarFile = this.readJarFromUrl(jarUrl);){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            WSFSaxRead wsfReader = new WSFSaxRead();
            while (jarEntries.hasMoreElements()) {
                String entryName;
                JarEntry entry = jarEntries.nextElement();
                if (entry.isDirectory() || !this.checkTemplatePrefixAndSuffix(entryName = entry.getName())) continue;
                LOG.debug("[WSF-ParamValidate] Begin parse validate-template: {}.", (Object)entryName);
                URL entryUrl = Resources.getResourceURL(entryName);
                Document document = wsfReader.read(entryUrl);
                this.parseParamTemplate(document.getRootElement());
                LOG.debug("[WSF-ParamValidate] End parse validate-template: {}.", (Object)entryName);
            }
        }
        catch (IOException | DocumentException ex) {
            throw new ValidateException("Can't find or parse the validate-template file in jar.", ex);
        }
    }

    private void parseCombinedValidators(URL jarUrl) throws ValidateException {
        try (JarFile jarFile = this.readJarFromUrl(jarUrl);){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            WSFSaxRead wsfReader = new WSFSaxRead();
            while (jarEntries.hasMoreElements()) {
                String entryName;
                JarEntry entry = jarEntries.nextElement();
                if (entry.isDirectory() || !this.checkValidatorsPrefixAndSuffix(entryName = entry.getName())) continue;
                LOG.debug("[WSF-ParamValidate] Begin parse validate-validator: {}.", (Object)entryName);
                URL entryUrl = Resources.getResourceURL(entryName);
                Document document = wsfReader.read(entryUrl);
                this.parseValidatorsTemplates(document.getRootElement());
                LOG.debug("[WSF-ParamValidate] End parse validate-validator: {}.", (Object)entryName);
            }
        }
        catch (IOException | DocumentException ex) {
            throw new ValidateException("Can't find or parse the validate-validator file in jar.", ex);
        }
    }

    private void parseValidateRule(URL jarUrl) throws ValidateException {
        try (JarFile jarFile = this.readJarFromUrl(jarUrl);){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            WSFSaxRead wsfReader = new WSFSaxRead();
            while (jarEntries.hasMoreElements()) {
                String entryName;
                JarEntry entry = jarEntries.nextElement();
                if (entry.isDirectory() || !this.checkFilePrefixAndSuffix(entryName = entry.getName())) continue;
                LOG.debug("[WSF-ParamValidate] Begin parse validate-rule: {}.", (Object)entryName);
                URL entryUrl = Resources.getResourceURL(entryName);
                Document document = wsfReader.read(entryUrl);
                this.addParamValidators(document.getRootElement());
                LOG.debug("[WSF-ParamValidate] End parse validate-rule: {}.", (Object)entryName);
            }
        }
        catch (IOException | DocumentException ex) {
            throw new ValidateException("Can't find or parse the validate-rule file in jar.", ex);
        }
    }

    private JarFile readJarFromUrl(URL jarUrl) throws ValidateException {
        try {
            URLConnection connect = jarUrl.openConnection();
            if (connect instanceof JarURLConnection) {
                JarURLConnection jarConnection = (JarURLConnection)connect;
                return jarConnection.getJarFile();
            }
            throw new ValidateException("The Jar URL isn't correct.");
        }
        catch (IOException e) {
            throw new ValidateException(e);
        }
    }
}

