/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.manager;

import com.huawei.security.validator.bean.BasicParamConfigBean;
import com.huawei.security.validator.bean.CommonConfigsBean;
import com.huawei.security.validator.bean.ErrorMessage;
import com.huawei.security.validator.bean.Parameter;
import com.huawei.security.validator.bean.ValidateRuleBean;
import com.huawei.security.validator.bean.ValidatorBean;
import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.bean.XMLParamNumberCheckBean;
import com.huawei.security.validator.config.FileCache;
import com.huawei.security.validator.exception.ParamValueValidateFailException;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.AbstractJsonValidator;
import com.huawei.security.validator.outerinterface.AbstractRequestValidator;
import com.huawei.security.validator.outerinterface.AbstractUrlPathValidator;
import com.huawei.security.validator.outerinterface.AbstractXMLValidator;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.InternalMessage;
import com.huawei.security.validator.util.JsonUtil;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.PathUtil;
import com.huawei.security.validator.util.PublicData;
import com.huawei.security.validator.util.ValidateFailErrorUtil;
import com.huawei.security.validator.util.ValidatorUtil;
import com.huawei.security.validator.util.XMLProcessUtil;
import com.huawei.security.validator.validators.ValidatorFactory;
import com.huawei.security.validator.web.XmlParameter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractProcessValidate {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final Logger LOG = WSFValidatorLog.getLogger();
    protected CommonConfigsBean configsBean = FileCache.getInstance().getCommonConfigsBean();

    public abstract void validatorParam(Parameter var1) throws ParamValueValidateFailException, ParseRequestDataException, ValidateException;

    protected List<String> decodeParamValue(List<String> paramValue, boolean decode, String encode) throws ValidateException {
        if (paramValue == null) {
            return new ArrayList<String>(0);
        }
        try {
            if (decode) {
                this.setParamValue(paramValue);
            }
            if ("UTF-8".equalsIgnoreCase(encode)) {
                return paramValue;
            }
            String charsets = encode == null ? DEFAULT_CHARSET : encode;
            for (int i = 0; i < paramValue.size(); ++i) {
                if (!EmptyUtils.hasText(paramValue.get(i))) continue;
                paramValue.set(i, new String(paramValue.get(i).getBytes(charsets), StandardCharsets.UTF_8));
            }
            return paramValue;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("[WSF-ParamValidate] Could not decode params with encoding {}.", (Object)LogUtils.cleanLog(encode));
            throw new ValidateException("Could not decode params with encoding " + LogUtils.cleanLog(encode), e);
        }
    }

    private void setParamValue(List<String> paramValue) throws UnsupportedEncodingException {
        for (int i = 0; i < paramValue.size(); ++i) {
            if (!EmptyUtils.hasText(paramValue.get(i))) continue;
            paramValue.set(i, URLDecoder.decode(paramValue.get(i), "UTF-8"));
        }
    }

    protected boolean isRequire(boolean isRequire, String paramValue) {
        if (isRequire) {
            return true;
        }
        if (paramValue == null) {
            LOG.info("[WSF-ParamValidate] The paramValue is null.");
            return false;
        }
        if (this.configsBean.isAllowEmptyValue() && paramValue.length() == 0) {
            LOG.info("[WSF-ParamValidate] The require is false and paramValue is empty.");
            return false;
        }
        return true;
    }

    protected void emptyNotRequiredHandler(Map<String, ValidatorResult> resultMap, String paramName) {
        LOG.info("[WSF-ParamValidate] The required is false and parameter is null.");
        LOG.info("[WSF-ParamValidate] ParamName: {}, validate result: true.", (Object)LogUtils.cleanLog(paramName));
        resultMap.put(paramName, new ValidatorResult(true));
    }

    protected void emptyRequiredHandler(String paramName, ErrorMessage error, Map<String, ValidatorResult> resultMap) throws ParamValueValidateFailException {
        LOG.error("[WSF-ParamValidate] The required is true and parameter is null.");
        LOG.error("[WSF-ParamValidate] ParamName: {}, validate result: false.", (Object)LogUtils.cleanLog(paramName));
        ValidatorResult result = new ValidatorResult(false);
        error.setErrorMessage(InternalMessage.getMessage(error.getErrorMessage()));
        error.setErrorCode("PARAM_VALUE_CANNOT_NULL");
        result.addErrorMessageParams(error);
        resultMap.put(paramName, result);
        ValidateFailErrorUtil.throwParamValueValidateFailException(resultMap);
    }

    protected boolean isNeedCheck(boolean isRequire, String paramName, Map<String, List<String>> paramValueMap, ErrorMessage error, Map<String, ValidatorResult> resultMap) throws ParamValueValidateFailException {
        if (EmptyUtils.isEmpty(paramValueMap)) {
            if (isRequire) {
                this.emptyRequiredHandler(paramName, error, resultMap);
            } else {
                this.emptyNotRequiredHandler(resultMap, paramName);
                return false;
            }
        }
        return true;
    }

    protected boolean isNeedCheck(boolean isRequire, String paramName, Collection<String> paramValueList, ErrorMessage error, Map<String, ValidatorResult> resultMap) throws ParamValueValidateFailException {
        if (EmptyUtils.isEmpty(paramValueList)) {
            if (isRequire) {
                this.emptyRequiredHandler(paramName, error, resultMap);
            } else {
                this.emptyNotRequiredHandler(resultMap, paramName);
                return false;
            }
        }
        return true;
    }

    protected ValidatorResult validators(BasicParamConfigBean bean2, String paramValue, PublicData publicData) throws ValidateException {
        ValidatorResult result = new ValidatorResult(true);
        ErrorMessage error = new ErrorMessage(bean2.getErrorKey(), bean2.getErrorMessage());
        boolean isEmptyMessage = !EmptyUtils.hasLength(error.getErrorMessage());
        block0: for (ValidatorBean validator : bean2.getValidatorList()) {
            if (!result.isValidateResule()) break;
            String refInfo = validator.getValidatorAttributeValue().get("ref");
            if (EmptyUtils.isEmpty(refInfo)) {
                if (isEmptyMessage) {
                    error.setErrorMessage(validator.getValidatorAttributeValue().get("errorMessage"));
                }
                result = this.doValidate(validator, paramValue, error, publicData);
                continue;
            }
            LOG.debug("[WSF-ParamValidate] The validator is reference common config.");
            Map<String, List<ValidatorBean>> validatorMap = this.configsBean.getCommonValidatorsMap();
            if (EmptyUtils.isEmpty(validatorMap) || EmptyUtils.isEmpty((Collection)validatorMap.get(refInfo))) {
                LOG.error("[WSF-ParamValidate] The validator reference of common, but common config is not config.");
                result = ValidatorUtil.getValidateResult(error, "REFER_COMMON_VALIDATOR_FAIL");
                break;
            }
            List<ValidatorBean> validatorList = validatorMap.get(refInfo);
            for (ValidatorBean validatorObject : validatorList) {
                if (isEmptyMessage) {
                    error.setErrorMessage(validatorObject.getValidatorAttributeValue().get("errorMessage"));
                }
                if ((result = this.doValidate(validatorObject, paramValue, error, publicData)).isValidateResule()) continue;
                continue block0;
            }
        }
        return result;
    }

    protected void handleNotConfigValidator(Map<String, ValidatorResult> resultMap, String paramName) throws ParamValueValidateFailException {
        LOG.error("[WSF-ParamValidate] The parameter is not config validators.");
        ErrorMessage error = new ErrorMessage();
        error.setErrorKey("NOT_CONFIG_PARAMETER_VALIDATOR");
        error.setErrorMessage("NOT_CONFIG_PARAMETER_VALIDATOR");
        error.setErrorCode("NOT_CONFIG_PARAMETER_VALIDATOR");
        resultMap.put(paramName, ValidatorUtil.getValidateResult(error));
        LOG.error("[WSF-ParamValidate] ParamName:{}, validate result: false.", (Object)LogUtils.cleanLog(paramName));
        ValidateFailErrorUtil.throwParamValueValidateFailException(resultMap);
    }

    protected void checkMaxArraySize(Map<String, ValidatorResult> resultMap, int paramListSize, BasicParamConfigBean parameterObject, String paramName) throws ParamValueValidateFailException {
        if (this.configsBean.isLimitArraySize() && paramListSize > parameterObject.getMaxArraySize()) {
            ErrorMessage error = new ErrorMessage();
            error.setErrorKey(parameterObject.getErrorKey());
            error.setErrorMessage(parameterObject.getErrorMessage());
            error.setErrorCode("ARRAY_LARGER_THAN_MAX_SIZE");
            ValidatorResult resultParam = ValidatorUtil.getValidateResult(error);
            resultMap.put(paramName, resultParam);
            LOG.error("[WSF-ParamValidate] The size of the value list is larger than the set config.");
            LOG.error("[WSF-ParamValidate] ParamName: {}, validate result: false.", (Object)LogUtils.cleanLog(paramName));
            ValidateFailErrorUtil.throwParamValueValidateFailException(resultMap);
        }
    }

    protected void checkJsonParamNum(Map<String, List<String>> jsonInfoMap, ValidateRuleBean validateObject) throws ParamValueValidateFailException {
        if (!this.isAllParamCheck(validateObject, this.configsBean.isJsonAllParamCheck())) {
            return;
        }
        LOG.info("[WSF-ParamValidate] Need validate json parameter number.");
        if (jsonInfoMap.isEmpty()) {
            return;
        }
        Set<String> jsonUrlSet = this.configsBean.getJsonParam(validateObject.getUrl());
        if (EmptyUtils.isEmpty(jsonUrlSet)) {
            jsonUrlSet = this.configsBean.getPublicJsonParam();
        }
        for (String jsonKey : jsonUrlSet) {
            if (jsonKey.startsWith("[")) {
                jsonKey = jsonKey.replace("[", "");
                jsonKey = jsonKey.replace("]", "");
            }
            JsonUtil.removeContainKey(jsonInfoMap, jsonKey);
        }
        JsonUtil.removeStarContainKey(jsonInfoMap, jsonUrlSet);
        if (!jsonInfoMap.isEmpty()) {
            LOG.error("[WSF-ParamValidate] Config parameter is incomplete, validate fail.");
            for (String jsonName : jsonInfoMap.keySet()) {
                LOG.error("[WSF-ParamValidate] Not config jsonKey is {}.", (Object)LogUtils.cleanLog(jsonName));
                ValidateFailErrorUtil.throwParamConfigValidateFailException(jsonName);
            }
        }
    }

    protected void xmlParamValidator(List<BasicParamConfigBean> noteList, Map<String, XMLParamNumberCheckBean> xmlNodeMap, XmlParameter xmlParameter, Map<String, ValidatorResult> resultMap, PublicData publicData) throws ParamValueValidateFailException, ValidateException, ParseRequestDataException {
        Document doc = PathUtil.parse(xmlParameter.getDocument()).orElse(null);
        Map<String, String> nameSpaces = PathUtil.getNameSpaces(xmlParameter.getDocument());
        for (BasicParamConfigBean parameterObject : noteList) {
            boolean isRequire = parameterObject.isRequired();
            String paramName = parameterObject.getName();
            LOG.info("[WSF-ParamValidate] Parameter Name: {} begin validate.", (Object)paramName);
            List<ValidatorBean> validatorsList = parameterObject.getValidatorList();
            if (EmptyUtils.isEmpty(validatorsList)) {
                this.handleNotConfigValidator(resultMap, paramName);
            }
            ErrorMessage error = new ErrorMessage(parameterObject.getErrorKey(), parameterObject.getErrorMessage());
            Map<String, List<String>> validateXpathInfoMap = this.getValidateXpathInfoMap(xmlNodeMap, doc, paramName, nameSpaces);
            if (!this.isNeedCheck(isRequire, paramName, validateXpathInfoMap, error, resultMap)) continue;
            ValidatorResult result = this.getValidatorResult(resultMap, publicData, parameterObject, validateXpathInfoMap);
            resultMap.put(paramName, result);
            LOG.info("[WSF-ParamValidate] ParamName: {}, validate result: true.", (Object)LogUtils.cleanLog(paramName));
        }
    }

    private ValidatorResult getValidatorResult(Map<String, ValidatorResult> resultMap, PublicData publicData, BasicParamConfigBean parameterObject, Map<String, List<String>> validateXpathInfoMap) throws ParamValueValidateFailException, ValidateException {
        ValidatorResult result = new ValidatorResult();
        boolean isRequire = parameterObject.isRequired();
        String paramName = parameterObject.getName();
        for (Map.Entry<String, List<String>> entry : validateXpathInfoMap.entrySet()) {
            List<String> validateValueList = entry.getValue();
            this.checkMaxArraySize(resultMap, validateValueList.size(), parameterObject, paramName);
            for (String paramValue : validateValueList) {
                if (!this.isRequire(isRequire, paramValue)) continue;
                result = this.validators(parameterObject, paramValue, publicData);
                this.checkResult(resultMap, paramName, result, paramValue);
            }
            LOG.info("[WSF-ParamValidate] Parameter xpath: {}, validate result: true.", (Object)entry.getKey());
        }
        return result;
    }

    private void checkResult(Map<String, ValidatorResult> resultMap, String paramName, ValidatorResult result, String paramValue) throws ParamValueValidateFailException {
        if (!result.isValidateResule()) {
            if (result.getParamValue() == null) {
                result.setParamValue(paramValue);
            }
            resultMap.put(paramName, result);
            LOG.error("[WSF-ParamValidate] ParamName: {}, validate result: false.", (Object)LogUtils.cleanLog(paramName));
            ValidateFailErrorUtil.throwParamValueValidateFailException(resultMap);
        }
    }

    protected void validateParam(String paramName, BasicParamConfigBean parameterObject, List<String> paramValueList, PublicData publicData, Map<String, ValidatorResult> resultMap) throws ParamValueValidateFailException, ValidateException {
        LOG.info("[WSF-ParamValidate] Parameter Name: {} begin validate.", (Object)paramName);
        List<ValidatorBean> validatorsList = parameterObject.getValidatorList();
        if (EmptyUtils.isEmpty(validatorsList)) {
            this.handleNotConfigValidator(resultMap, paramName);
        }
        this.checkMaxArraySize(resultMap, paramValueList.size(), parameterObject, paramName);
        ValidatorResult result = new ValidatorResult(true);
        for (String paramValue : paramValueList) {
            if (!this.isRequire(parameterObject.isRequired(), paramValue) || (result = this.validators(parameterObject, paramValue, publicData)).isValidateResule()) continue;
            if (result.getParamValue() == null) {
                result.setParamValue(paramValue);
            }
            resultMap.put(paramName, result);
            LOG.error("[WSF-ParamValidate] ParamName:{}, validate result: false.", (Object)LogUtils.cleanLog(paramName));
            ValidateFailErrorUtil.throwParamValueValidateFailException(resultMap);
        }
        resultMap.put(paramName, result);
        LOG.info("[WSF-ParamValidate] ParamName: {}, validate result: true.", (Object)LogUtils.cleanLog(paramName));
    }

    protected void validateXmlEntity(List<BasicParamConfigBean> entityList, PublicData publicData, boolean isContainXmlEntity, Map<String, ValidatorResult> resultMap) throws ValidateException, ParamValueValidateFailException {
        if (isContainXmlEntity && "permit".equals(this.configsBean.getXmlEntity())) {
            LOG.info("[WSF-ParamValidate] Xml entity config is : {}, so need validate xml entity.", (Object)"permit");
            if (EmptyUtils.isEmpty(entityList)) {
                LOG.error("[WSF-ParamValidate] Xml entity validate not config.");
                ErrorMessage error = new ErrorMessage();
                error.setErrorKey("DOCTYPE-ENTITY-VALIDATE");
                error.setErrorMessage("Xml entity validate not config.");
                error.setErrorCode("DOCTYPE_ENTITY_VALIDATE_ERROR");
                ValidatorResult result = ValidatorUtil.getValidateResult(error);
                resultMap.put("DOCTYPE-ENTITY-VALIDATE", result);
                ValidateFailErrorUtil.throwParamValueValidateFailException(resultMap);
            }
            for (BasicParamConfigBean bean2 : entityList) {
                ValidatorResult result = this.validators(bean2, "", publicData);
                resultMap.put("DOCTYPE-ENTITY-VALIDATE", result);
                if (result.isValidateResule()) continue;
                ValidateFailErrorUtil.throwParamValueValidateFailException(resultMap);
            }
        }
    }

    protected boolean isAllParamCheck(ValidateRuleBean bean2, boolean globalParamCheck) {
        if ("false".equalsIgnoreCase(bean2.getAllParameterCheck())) {
            return false;
        }
        if ("true".equalsIgnoreCase(bean2.getAllParameterCheck())) {
            return true;
        }
        return globalParamCheck;
    }

    protected void processJsonNodeList(List<BasicParamConfigBean> jsonNoteList, Map<String, ValidatorResult> resultMap, Map<String, List<String>> jsonAllInfoMap, PublicData publicData) throws ParamValueValidateFailException, ValidateException {
        if (jsonNoteList == null) {
            return;
        }
        for (BasicParamConfigBean parameterObject : jsonNoteList) {
            Map<String, List<String>> jsonNodeMap;
            boolean isRequire = parameterObject.isRequired();
            String paramName = parameterObject.getName();
            ErrorMessage error = new ErrorMessage(parameterObject.getErrorKey(), parameterObject.getErrorMessage());
            if (paramName.startsWith("[")) {
                paramName = paramName.replace("[", "");
                paramName = paramName.replace("]", "");
            }
            if (!this.isNeedCheck(isRequire, paramName, jsonNodeMap = JsonUtil.getJsonValueList(jsonAllInfoMap, paramName), error, resultMap)) {
                jsonAllInfoMap.remove(paramName);
                continue;
            }
            for (Map.Entry<String, List<String>> entry : jsonNodeMap.entrySet()) {
                String newParamName = entry.getKey();
                List<String> jsonValueList = entry.getValue();
                jsonAllInfoMap.remove(newParamName);
                if (!this.isNeedCheck(isRequire, newParamName, jsonValueList, error, resultMap)) continue;
                this.validateParam(newParamName, parameterObject, jsonValueList, publicData, resultMap);
            }
        }
    }

    protected boolean validateExceptionProcess(Map<String, ValidatorResult> resultMap, ValidateException ex) throws ParamValueValidateFailException {
        ValidatorResult result = new ValidatorResult();
        String errorMessage = "PARAMETER_VALIDATOR_SET_ERROR";
        ErrorMessage error = new ErrorMessage(errorMessage, ex.getMessage());
        ValidatorUtil.setErrorResult(result, error, errorMessage, new Object[0]);
        ParamValueValidateFailException validateFailException = new ParamValueValidateFailException();
        resultMap.put(errorMessage, result);
        validateFailException.setResultMap(resultMap);
        throw validateFailException;
    }

    private Map<String, List<String>> getValidateXpathInfoMap(Map<String, XMLParamNumberCheckBean> xmlNodeMap, Document doc, String paramName, Map<String, String> nameSpaces) throws ParseRequestDataException {
        HashMap<String, List<String>> validateXpathInfoMap = null;
        XMLParamNumberCheckBean xmlParamBean = xmlNodeMap.get(paramName);
        if (xmlParamBean != null) {
            List<String> paramValueList = xmlParamBean.getValueList();
            validateXpathInfoMap = new HashMap<String, List<String>>(16);
            validateXpathInfoMap.put(paramName, paramValueList);
            xmlParamBean.setConfigParamValueNumbers(xmlParamBean.getRequestValueNumbers());
        } else {
            HashMap<Node, String> pattenXpathMap = new HashMap<Node, String>(16);
            validateXpathInfoMap = XMLProcessUtil.getXMLParamInfo(doc, nameSpaces, paramName, pattenXpathMap);
            this.processNodeMap(validateXpathInfoMap, xmlNodeMap, paramName, pattenXpathMap);
        }
        return validateXpathInfoMap;
    }

    protected void checkXmlParamNumber(ValidateRuleBean validateObject, Map<String, XMLParamNumberCheckBean> xmlNodeMap, XmlParameter xmlParameter, List<BasicParamConfigBean> noteList) throws ParamValueValidateFailException, ParseRequestDataException {
        LOG.info("[WSF-ParamValidate] Check exist not validate xml node.");
        Set<String> xpathUrlSet = this.configsBean.getXmlParamSet(validateObject.getUrl());
        if (EmptyUtils.isEmpty(xpathUrlSet)) {
            xpathUrlSet = this.configsBean.getPublicXmlParam();
        }
        Document doc = PathUtil.parse(xmlParameter.getDocument()).orElse(null);
        Map<String, String> nameSpaces = PathUtil.getNameSpaces(xmlParameter.getDocument());
        for (String string : xpathUrlSet) {
            if (!xmlNodeMap.containsKey(string)) {
                this.checkXpath(string, xmlNodeMap, doc, noteList, nameSpaces);
            }
            xmlNodeMap.remove(string);
        }
        for (Map.Entry entry : xmlNodeMap.entrySet()) {
            XMLParamNumberCheckBean bean2 = (XMLParamNumberCheckBean)entry.getValue();
            if (bean2.getRequestValueNumbers() <= bean2.getConfigParamValueNumbers()) continue;
            LOG.error("[WSF-ParamValidate] Config parameter validate fail. xpath is : {}, config parameter numbers is : {}, request parameter numbers is : {}.", LogUtils.cleanLog((String)entry.getKey()), bean2.getConfigParamValueNumbers(), bean2.getRequestValueNumbers());
            ValidateFailErrorUtil.throwParamConfigValidateFailException((String)entry.getKey());
        }
    }

    private void checkXpath(String xpath, Map<String, XMLParamNumberCheckBean> xmlNodeMap, Document doc, List<BasicParamConfigBean> noteList, Map<String, String> nameSpaces) throws ParseRequestDataException {
        for (BasicParamConfigBean whiteXpath : noteList) {
            if (!xpath.equals(whiteXpath.getName())) continue;
            return;
        }
        HashMap<Node, String> pattenXpathMap = new HashMap<Node, String>(16);
        Map<String, List<String>> whiteXpathMap = XMLProcessUtil.getXMLParamInfo(doc, nameSpaces, xpath, pattenXpathMap);
        for (String whitePath : whiteXpathMap.keySet()) {
            XMLParamNumberCheckBean bean2 = xmlNodeMap.get(whitePath);
            if (bean2 == null) continue;
            this.checkXPathMap(pattenXpathMap, whitePath, bean2);
        }
    }

    private void checkXPathMap(Map<Node, String> pattenXpathMap, String whitePath, XMLParamNumberCheckBean bean2) {
        for (Node element : pattenXpathMap.keySet()) {
            if (element.getNodeType() == 1) {
                if (PathUtil.getFullXPath(element).equals(whitePath)) {
                    bean2.getConfigPatternXpathObjectMap().put(element, "");
                    continue;
                }
                LOG.debug("[WSF-ParamValidate] The node's xpath is not equal the current element.");
                continue;
            }
            if (element.getNodeType() == 2) {
                if (PathUtil.getFullXPath(element).equals(whitePath)) {
                    bean2.getConfigPatternXpathObjectMap().put(element, "");
                    continue;
                }
                LOG.debug("[WSF-ParamValidate] The node's xpath is not equal the current attribute.");
                continue;
            }
            LOG.error("[WSF-ParamValidate] Type is error.");
        }
    }

    private void processNodeMap(Map<String, List<String>> validateXpathInfoMap, Map<String, XMLParamNumberCheckBean> xmlNodeMap, String paramName, Map<Node, String> pattenXpathMap) {
        for (String xPath : validateXpathInfoMap.keySet()) {
            XMLParamNumberCheckBean bean2 = xmlNodeMap.get(xPath);
            if (bean2 == null) {
                LOG.error("[WSF-ParamValidate] ParamName:{}, the xml node validate is not supported.", (Object)LogUtils.cleanLog(paramName));
                return;
            }
            this.checkXmlNodeNumber(pattenXpathMap, xPath, bean2);
        }
    }

    private void checkXmlNodeNumber(Map<Node, String> pattenXpathMap, String xPath, XMLParamNumberCheckBean bean2) {
        for (Node element : pattenXpathMap.keySet()) {
            if (element.getNodeType() == 1) {
                if (PathUtil.getFullXPath(element).equals(xPath)) {
                    bean2.getConfigPatternXpathObjectMap().put(element, "");
                    continue;
                }
                LOG.debug("[WSF-ParamValidate] The node's xpath is not equal the current element.");
                continue;
            }
            if (element.getNodeType() == 2) {
                if (PathUtil.getFullXPath(element).equals(xPath)) {
                    bean2.getConfigPatternXpathObjectMap().put(element, "");
                    continue;
                }
                LOG.debug("[WSF-ParamValidate] The node's xpath is not equal the current attribute.");
                continue;
            }
            LOG.debug("[WSF-ParamValidate] The node's xpath is not equal.");
        }
    }

    private ValidatorResult doValidate(ValidatorBean validator, String paramValue, ErrorMessage error, PublicData publicData) {
        HashMap<String, String> validatorAttribute = validator.getValidatorAttributeValue();
        String validatorName = validatorAttribute.get("name");
        if (ValidatorEnum.USER_DEFINED_VALIDATOR.name().equals(validatorName)) {
            String checkClass = validatorAttribute.get("checkClass");
            try {
                ValidatorResult validatorResult = this.checkParam(checkClass, paramValue, validatorAttribute, error, publicData);
                if (validatorResult == null) {
                    LOG.error("[WSF-ParamValidate] The validated result from the {} validator class is null.", (Object)LogUtils.cleanLog(checkClass));
                    return ValidatorUtil.getValidateResult(error, validatorName);
                }
                return validatorResult;
            }
            catch (ValidateException e) {
                LOG.error("[WSF-ParamValidate] {} validator class load fail, {}", (Object)LogUtils.cleanLog(checkClass), (Object)e.getMessage());
                return ValidatorUtil.getValidateResult(error, validatorName);
            }
        }
        String validatorClassName = ValidatorEnum.getEnumFromString(validatorName).getClassName();
        if (EmptyUtils.isEmpty(validatorClassName)) {
            LOG.error("[WSF-ParamValidate] Validator name config error, config validator name is {}.", (Object)LogUtils.cleanLog(validatorName));
            return ValidatorUtil.getValidateResult(error, "CANNOT_FIND_VALIDATOR_NAME");
        }
        try {
            Validator validatorInst = ValidatorFactory.getValidator(validatorClassName);
            ValidatorResult validatorResult = validatorInst.inputValidate(paramValue, validatorAttribute, error.getErrorKey(), error.getErrorMessage());
            if (validatorResult == null) {
                LOG.error("[WSF-ParamValidate] The validated result from the {} validator class is null.", (Object)validatorClassName);
                return ValidatorUtil.getValidateResult(error, validatorName);
            }
            return validatorResult;
        }
        catch (ValidateException e) {
            LOG.error("[WSF-ParamValidate] {} validator class load fail, {}", (Object)validatorClassName, (Object)e.getMessage());
            return ValidatorUtil.getValidateResult(error, validatorName);
        }
    }

    private ValidatorResult checkParam(String checkClass, String paramValue, HashMap<String, String> validateRuleMap, ErrorMessage error, PublicData publicData) throws ValidateException {
        if (!EmptyUtils.hasText(checkClass)) {
            throw new ValidateException("The name of defined validator for validating is empty.");
        }
        Validator definedValidator = ValidatorFactory.getValidator(checkClass);
        if (definedValidator instanceof AbstractJsonValidator || definedValidator instanceof AbstractRequestValidator || definedValidator instanceof AbstractXMLValidator || definedValidator instanceof AbstractUrlPathValidator) {
            return definedValidator.inputValidate(publicData, validateRuleMap, error.getErrorKey(), error.getErrorMessage());
        }
        return definedValidator.inputValidate(paramValue, validateRuleMap, error.getErrorKey(), error.getErrorMessage());
    }
}

