/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.manager;

import com.huawei.security.validator.bean.BasicParamConfigBean;
import com.huawei.security.validator.bean.HeaderParam;
import com.huawei.security.validator.bean.Parameter;
import com.huawei.security.validator.bean.ValidatorBean;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.exception.ParamValueValidateFailException;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.manager.AbstractProcessValidate;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.LogUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.springframework.util.AntPathMatcher;

public class RequestHeaderProcessValidate
extends AbstractProcessValidate {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private final AntPathMatcher matcher = new AntPathMatcher();

    @Override
    public void validatorParam(Parameter paramObject) {
    }

    public void validatorParam(List<HeaderParam> headerParamList, HttpServletRequest request) throws ParamValueValidateFailException, ValidateException {
        String requestUri = this.getNormalizeRequestURI(request);
        LOG.debug("[WSF-HeaderValidate] Begin to validate request-header, request url: {}.", (Object)LogUtils.cleanLog(requestUri));
        this.matcher.setTrimTokens(false);
        for (HeaderParam rule : headerParamList) {
            String headerName = rule.getName();
            String urlPattern = rule.getUrlPattern();
            boolean forbidden = rule.isForbidden();
            String headerValue = request.getHeader(headerName);
            if (!this.matcher.match(urlPattern, requestUri)) {
                LOG.debug("[WSF-HeaderValidate] Don't need to validate request-header: {}.", (Object)LogUtils.cleanLog(headerName));
                continue;
            }
            if (forbidden && EmptyUtils.hasText(headerValue)) {
                LOG.error("[WSF-HeaderValidate] Request-header validate failed, reason is header is forbidden. Header name: " + LogUtils.cleanLog(headerName));
                throw new ParamValueValidateFailException("Request header : " + LogUtils.cleanLog(headerName) + " is forbidden.");
            }
            if (forbidden || headerValue == null) continue;
            this.validateParam(headerName, rule, headerValue);
        }
    }

    protected void validateParam(String paramName, BasicParamConfigBean parameterObject, String paramValue) throws ParamValueValidateFailException, ValidateException {
        LOG.info("[WSF-HeaderValidate] Begin validate request-header: {}.", (Object)LogUtils.cleanLog(paramName));
        List<ValidatorBean> validatorsList = parameterObject.getValidatorList();
        if (EmptyUtils.isEmpty(validatorsList)) {
            LOG.error("[WSF-HeaderValidate] Request-header: {} does not config validator.", (Object)LogUtils.cleanLog(paramName));
            return;
        }
        ValidatorResult result = null;
        if (this.isRequire(parameterObject.isRequired(), paramValue)) {
            result = this.validators(parameterObject, paramValue, null);
        }
        if (result == null) {
            result = new ValidatorResult(true);
        }
        LOG.info("[WSF-HeaderValidate] Request-header: {}, validate result: {}.", (Object)LogUtils.cleanLog(paramName), (Object)result.isValidateResule());
        if (!result.isValidateResule()) {
            throw new ParamValueValidateFailException("Request-header: " + LogUtils.cleanLog(paramName) + " is validate failed.");
        }
    }

    private String getNormalizeRequestURI(HttpServletRequest request) {
        String uri = request.getServletPath();
        if (request.getPathInfo() != null) {
            uri = uri + request.getPathInfo();
        }
        if (uri.length() > 0) {
            return uri;
        }
        return "/";
    }
}

