/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.manager;

import com.huawei.security.validator.bean.BasicParamConfigBean;
import com.huawei.security.validator.bean.ErrorMessage;
import com.huawei.security.validator.bean.Parameter;
import com.huawei.security.validator.bean.ParameterConfigBean;
import com.huawei.security.validator.bean.ValidateRuleBean;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.bean.XMLParamNumberCheckBean;
import com.huawei.security.validator.exception.ParamValueValidateFailException;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.manager.AbstractProcessValidate;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.PublicData;
import com.huawei.security.validator.web.XmlParameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XmlProcessValidate
extends AbstractProcessValidate {
    private static final int RESULT_MAP_SIZE = 8;
    private ValidateRuleBean validateObject;
    private PublicData publicData;

    public XmlProcessValidate(ValidateRuleBean validateRuleBean, PublicData publicData) {
        this.validateObject = validateRuleBean;
        this.publicData = publicData;
    }

    @Override
    public void validatorParam(Parameter paramObject) throws ParamValueValidateFailException, ParseRequestDataException, ValidateException {
        XmlParameter xmlParameter = null;
        if (!(paramObject instanceof XmlParameter)) {
            throw new ValidateException("The parameter type is not as expected.");
        }
        xmlParameter = (XmlParameter)paramObject;
        if (this.isAllParamCheck(this.validateObject, this.configsBean.isXmlAllParamCheck())) {
            HashMap<String, ValidatorResult> resultMap = new HashMap<String, ValidatorResult>(8);
            List<BasicParamConfigBean> noteList = null;
            try {
                noteList = this.validateObject.getParamList(this.publicData.getRequestParamSetName());
            }
            catch (ValidateException ex) {
                this.validateExceptionProcess(resultMap, ex);
            }
            this.validateXmlEntity(this.validateObject.getXMLEntityParamList(this.publicData.getRequestParamSetName()), this.publicData, LogUtils.isContainXmlEntity(xmlParameter.getXmlData()), resultMap);
            Map<String, XMLParamNumberCheckBean> xmlNodeMap = xmlParameter.getAllParamInfo();
            if (noteList != null) {
                this.xmlParamValidator(noteList, xmlNodeMap, xmlParameter, resultMap, this.publicData);
                this.checkXmlParamNumber(this.validateObject, xmlNodeMap, xmlParameter, noteList);
            }
        } else {
            this.validateParamNoCheckNumber(xmlParameter);
        }
    }

    private void validateParamNoCheckNumber(XmlParameter xmlParameter) throws ValidateException, ParamValueValidateFailException, ParseRequestDataException {
        HashMap<String, ValidatorResult> resultMap = new HashMap<String, ValidatorResult>(8);
        List<BasicParamConfigBean> xmlNoteList = null;
        try {
            xmlNoteList = this.validateObject.getParamList(this.publicData.getRequestParamSetName());
        }
        catch (ValidateException ex) {
            this.validateExceptionProcess(resultMap, ex);
        }
        this.validateXmlEntity(this.validateObject.getXMLEntityParamList(this.publicData.getRequestParamSetName()), this.publicData, LogUtils.isContainXmlEntity(xmlParameter.getXmlData()), resultMap);
        if (xmlNoteList != null) {
            for (BasicParamConfigBean basicParamConfigBean : xmlNoteList) {
                this.validatorParam(xmlParameter, resultMap, basicParamConfigBean);
            }
        }
    }

    private void validatorParam(XmlParameter xmlParameter, HashMap<String, ValidatorResult> resultMap, BasicParamConfigBean basicParamConfigBean) throws ParseRequestDataException, ParamValueValidateFailException, ValidateException {
        if (basicParamConfigBean instanceof ParameterConfigBean) {
            ParameterConfigBean parameterObject = (ParameterConfigBean)basicParamConfigBean;
            boolean isRequire = parameterObject.isRequired();
            String paramName = parameterObject.getName();
            ErrorMessage error = new ErrorMessage(parameterObject.getErrorKey(), parameterObject.getErrorMessage());
            List<String> paramValueList = xmlParameter.parseXmlValue(paramName);
            if (!this.isNeedCheck(isRequire, paramName, paramValueList, error, resultMap)) {
                return;
            }
            this.validateParam(paramName, parameterObject, paramValueList, this.publicData, resultMap);
        }
    }
}

