/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.outerinterface.defaultimp;

import com.huawei.security.validator.exception.ParamValueValidateFailException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.RequestHeaderValidateFailedHandler;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class RequestHeaderValidateFailedHandlerImpl
implements RequestHeaderValidateFailedHandler {
    public static final String ACCESS_DENIED_403 = "SPRING_SECURITY_403_EXCEPTION";
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private String errorPageURL;

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse resp, ParamValueValidateFailException validateFailedException) throws IOException, ServletException {
        if (!resp.isCommitted()) {
            if (this.errorPageURL != null) {
                req.setAttribute(ACCESS_DENIED_403, (Object)validateFailedException);
                resp.setStatus(403);
                RequestDispatcher requestDispatcher = req.getRequestDispatcher(this.errorPageURL);
                if (requestDispatcher == null) {
                    LOG.error("[WSF-ParamValidate] requestDispatcher is null");
                    return;
                }
                requestDispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            } else {
                resp.setStatus(403);
                resp.getWriter().write(validateFailedException.getMessage());
            }
        }
    }

    public void setErrorPage(String errordDispatcherURL) {
        if (errordDispatcherURL != null && !errordDispatcherURL.startsWith("/")) {
            throw new IllegalArgumentException("The errorPageURL must begin with '/'.");
        }
        this.errorPageURL = errordDispatcherURL;
    }
}

