/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.bean.BasicParamConfigBean;
import com.huawei.security.validator.config.FileCache;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.JsonConstant;
import com.huawei.security.validator.util.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class JsonUtil {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private static final int SUB_STRING_INDEX = 2;
    private static Pattern pattern = Pattern.compile("\\d{1,2}");

    private JsonUtil() {
    }

    public static void handleEmpty(String completeKey, Map<String, List<String>> dataMap) {
        String completeKeyTmp = completeKey.replace("@#9#%*@", ".");
        if (completeKeyTmp.startsWith(".")) {
            completeKeyTmp = completeKeyTmp.substring(1);
        }
        if (!dataMap.containsKey(completeKeyTmp)) {
            ArrayList valueList = new ArrayList(10);
            dataMap.put(completeKeyTmp, valueList);
        } else {
            LOG.warn("[WSF-ParamValidate] Traverse json data about {} have exist, but this is empty. it will skip.", (Object)completeKeyTmp);
        }
    }

    public static <T> void processJsonValue(T json, Map<String, List<String>> dataMap, String completeKey) {
        String completeKeyReplaced = JsonUtil.convertToOriginalKey(completeKey);
        if (dataMap.containsKey(completeKeyReplaced)) {
            if (json == null) {
                dataMap.get(completeKeyReplaced).add(null);
            } else {
                dataMap.get(completeKeyReplaced).add(String.valueOf(json));
            }
        } else {
            ArrayList<String> valueList = new ArrayList<String>(10);
            if (json == null) {
                valueList.add(null);
            } else {
                valueList.add(String.valueOf(json));
            }
            dataMap.put(completeKeyReplaced, valueList);
        }
        JsonUtil.handleParamListRefJsonKey(dataMap, completeKeyReplaced);
    }

    public static void handleParamListRefJsonKey(Map<String, List<String>> dataMap, String completeKeyReplaced) {
        if (dataMap.get("needCheckParam#@#").size() > 0) {
            List<String> paramList = dataMap.get("needCheckParamFormObj#@#");
            if (paramList != null) {
                paramList.remove(completeKeyReplaced);
            }
            if (!JsonUtil.checkKeyInDataMap(completeKeyReplaced, dataMap)) {
                dataMap.remove("needCheckParamFormValue#@#");
            } else {
                dataMap.put("needCheckParamFormValue#@#", new ArrayList());
            }
        }
    }

    public static boolean checkKeyInDataMap(String completeKeyReplaced, Map<String, List<String>> dataMap) {
        boolean needCheckFlag = false;
        List<String> needCheckParamList = dataMap.get("needCheckParam#@#");
        for (String jsonKey : needCheckParamList) {
            String concatKey;
            if (!jsonKey.startsWith(concatKey = completeKeyReplaced + "#@#")) continue;
            needCheckFlag = true;
            break;
        }
        boolean noNeedCheckFlag = false;
        List<String> noNeedCheckParamList = dataMap.get("noNeedCheckParam#@#");
        for (String jsonKey : noNeedCheckParamList) {
            if (!jsonKey.equals(completeKeyReplaced)) continue;
            noNeedCheckFlag = true;
            break;
        }
        return needCheckFlag || noNeedCheckFlag;
    }

    public static void handleCheckParamList(List<BasicParamConfigBean> jsonNoteList, List<String> needCheckParamList, List<String> noNeedCheckParamList) {
        for (BasicParamConfigBean basicParamConfigBean : jsonNoteList) {
            if (!EmptyUtils.isEmpty(basicParamConfigBean.getLevel())) {
                if (basicParamConfigBean.isRequired() && basicParamConfigBean.isListObjectCheck()) {
                    needCheckParamList.add(basicParamConfigBean.getName() + "#@#" + basicParamConfigBean.getLevel());
                }
                if (basicParamConfigBean.isListObjectCheck()) continue;
                noNeedCheckParamList.add(basicParamConfigBean.getName());
                continue;
            }
            if (!basicParamConfigBean.isListObjectCheck()) continue;
            LOG.warn("[WSF-ParamValidate] ListObjectCheck and level may be illegal.");
        }
    }

    public static void initCheckParamList(List<String> needCheckParamList, List<String> noNeedCheckParamList, Map<String, List<String>> dataMap) {
        JsonConstant.setCheckRes(false);
        dataMap.put("needCheckParam#@#", needCheckParamList);
        dataMap.put("noNeedCheckParam#@#", noNeedCheckParamList);
        dataMap.put("deepIndex#@#", Collections.singletonList("0"));
        dataMap.put("checkResult#@#", Collections.singletonList("0"));
    }

    public static void cleanCheckParamList(Map<String, List<String>> dataMap) {
        dataMap.remove("needCheckParam#@#");
        dataMap.remove("noNeedCheckParam#@#");
        dataMap.remove("needCheckParamFormObj#@#");
        dataMap.remove("needCheckParamFormValue#@#");
        dataMap.remove("deepIndex#@#");
        dataMap.remove("checkResult#@#");
    }

    public static int getJsonKeyLevel(String completeKey, List<String> needCheckParamList) {
        String completeKeyReplaced = JsonUtil.convertToOriginalKey(completeKey);
        if (needCheckParamList.size() > 0) {
            for (String needCheckParam : needCheckParamList) {
                if (!needCheckParam.startsWith(completeKeyReplaced)) continue;
                return Integer.parseInt(needCheckParam.substring(needCheckParam.lastIndexOf("#@#") + "#@#".length()));
            }
        }
        return -1;
    }

    private static String convertToOriginalKey(String completeKey) {
        String completeKeySub = completeKey.length() < "@#9#%*@".length() ? "" : completeKey.substring("@#9#%*@".length());
        return completeKeySub.replace("@#9#%*@", ".");
    }

    public static void handleDataMapOutOfJsonArray(Map<String, List<String>> dataMap, String completeKey) {
        List<String> relationKeyList;
        List<String> needCheckParamFormObjList = dataMap.get("needCheckParamFormObj#@#");
        if (!EmptyUtils.isEmpty(needCheckParamFormObjList) && !EmptyUtils.isEmpty(relationKeyList = JsonUtil.getListFromDataMapRefKey(completeKey, needCheckParamFormObjList))) {
            LOG.error("[WSF-ParamValidate] JSON data consistency check failed, Missing key :{}.", (Object)LogUtils.cleanLog(relationKeyList.toString()));
            dataMap.put("checkResult#@#", Collections.singletonList("1"));
        }
        dataMap.remove("needCheckParamFormObj#@#");
        dataMap.remove("needCheckParamFormValue#@#");
    }

    private static List<String> getListFromDataMapRefKey(String completeKey, List<String> remainNeedCheckParamList) {
        String completeKeyReplaced = JsonUtil.convertToOriginalKey(completeKey);
        ArrayList<String> relationKeyList = new ArrayList<String>();
        for (String remainKey : remainNeedCheckParamList) {
            if (!remainKey.startsWith(completeKeyReplaced)) continue;
            relationKeyList.add(remainKey);
        }
        return relationKeyList;
    }

    public static List<String> convertParamListFromCurrentKey(List<String> needCheckParamList) {
        ArrayList<String> needCheckParamListFromCurrentKey = new ArrayList<String>();
        for (String xmlParam : needCheckParamList) {
            String xmlParamSub = xmlParam.substring(0, xmlParam.indexOf("#@#"));
            needCheckParamListFromCurrentKey.add(xmlParamSub);
        }
        return needCheckParamListFromCurrentKey;
    }

    public static Map<String, List<String>> getJsonValueList(Map<String, List<String>> jsonInfoMap, String key) throws ValidateException {
        HashMap<String, List<String>> jsonNodeMap = new HashMap<String, List<String>>(jsonInfoMap.size());
        if (key.contains("{") && key.contains("}")) {
            DetailInfo info = new DetailInfo();
            JsonUtil.getJsonKey(key, info);
            StringBuilder nestingKeyBuilder = info.getNestingKeyBuffer();
            for (int i = info.getMinNestingLevel(); i <= info.getMaxNestingLevel(); ++i) {
                StringBuilder paramKeyBuilder = new StringBuilder(16);
                paramKeyBuilder.append(info.getKeyPart1());
                paramKeyBuilder.append((CharSequence)nestingKeyBuilder);
                paramKeyBuilder.append(info.getKeyPart3());
                String paramKeyStr = paramKeyBuilder.toString();
                if (jsonInfoMap.containsKey(paramKeyStr)) {
                    LOG.info("[WSF-ParamValidate] Config original jsonKey is {}, parse jsonKey is {}.", (Object)LogUtils.cleanLog(key), (Object)LogUtils.cleanLog(paramKeyStr));
                    jsonNodeMap.put(paramKeyStr, jsonInfoMap.get(paramKeyStr));
                }
                nestingKeyBuilder.append(info.getNestingKeyName());
                nestingKeyBuilder.append('.');
            }
            return jsonNodeMap;
        }
        jsonNodeMap.put(key, jsonInfoMap.get(key));
        return jsonNodeMap;
    }

    public static void removeContainKey(Map<String, List<String>> jsonInfoMap, String key) {
        if (key.contains("{") && key.contains("}")) {
            DetailInfo info = new DetailInfo();
            try {
                JsonUtil.getJsonKey(key, info);
            }
            catch (ValidateException e) {
                return;
            }
            StringBuilder nestingKeyBuffer = info.getNestingKeyBuffer();
            for (int i = info.getMinNestingLevel(); i <= info.getMaxNestingLevel(); ++i) {
                StringBuilder paramKeyBuilder = new StringBuilder(16);
                paramKeyBuilder.append(info.getKeyPart1());
                paramKeyBuilder.append((CharSequence)nestingKeyBuffer);
                paramKeyBuilder.append(info.getKeyPart3());
                String paramKeyStr = paramKeyBuilder.toString();
                if (jsonInfoMap.containsKey(paramKeyStr)) {
                    LOG.info("[WSF-ParamValidate] Config original json key is {}, parse json key is {}.", (Object)key, (Object)paramKeyStr);
                    jsonInfoMap.remove(paramKeyStr);
                }
                nestingKeyBuffer.append(info.getNestingKeyName());
                nestingKeyBuffer.append('.');
            }
        } else {
            jsonInfoMap.remove(key);
        }
    }

    public static void removeStarContainKey(Map<String, List<String>> jsonInfoMap, Set<String> jsonUrlSet) {
        Set<String> keys = jsonInfoMap.keySet();
        ArrayList<String> willRemoveKey = new ArrayList<String>(10);
        for (String filter : jsonUrlSet) {
            if (!filter.contains("*")) continue;
            JsonUtil.addWillRemoveKey(keys, willRemoveKey, filter);
        }
        for (String string : willRemoveKey) {
            jsonInfoMap.remove(string);
        }
    }

    private static void addWillRemoveKey(Set<String> keys, List<String> willRemoveKey, String filter) {
        String[] filterArrays = filter.split("\\.");
        for (String key : keys) {
            if (!JsonUtil.isMatch(filterArrays, key.split("\\."))) continue;
            willRemoveKey.add(key);
        }
    }

    private static boolean isMatch(String[] filterArrays, String[] keyArrays) {
        if (filterArrays.length != keyArrays.length) {
            return false;
        }
        boolean returnResult = true;
        int len = keyArrays.length;
        for (int i = 0; i < len; ++i) {
            if (!keyArrays[i].isEmpty() && !filterArrays[i].isEmpty() && (keyArrays[i].equals(filterArrays[i]) || "*".equals(filterArrays[i]))) continue;
            returnResult = false;
            break;
        }
        return returnResult;
    }

    private static DetailInfo getJsonKey(String key, DetailInfo info) throws ValidateException {
        boolean isErrorLevel;
        int firstCharBracket = key.indexOf(123);
        int firstCharBracket2 = key.indexOf(125);
        int lastCharBracket2 = 0;
        String[] arrayLevel = null;
        String nestingKeyName = key.substring(firstCharBracket + 1, firstCharBracket2);
        if (key.indexOf(123, firstCharBracket2) != -1) {
            lastCharBracket2 = key.lastIndexOf(125);
            String nestingLevel = key.substring(firstCharBracket2 + 2, lastCharBracket2);
            arrayLevel = nestingLevel.split(",");
        } else {
            lastCharBracket2 = firstCharBracket2;
        }
        int minNestingLevel = 0;
        int maxNestingLevel = 0;
        int configMaxNestingLevel = FileCache.getInstance().getCommonConfigsBean().getJsonKeyMaxNesting();
        if (arrayLevel == null) {
            minNestingLevel = 1;
            maxNestingLevel = configMaxNestingLevel;
        } else if (arrayLevel.length == 1) {
            JsonUtil.invalidLevelCheck(key, arrayLevel);
            minNestingLevel = Integer.parseInt(arrayLevel[0]);
            maxNestingLevel = configMaxNestingLevel;
        } else if (arrayLevel.length == 2) {
            JsonUtil.invalidLevelCheck(key, arrayLevel);
            minNestingLevel = Integer.parseInt(arrayLevel[0]);
            maxNestingLevel = Integer.parseInt(arrayLevel[1]);
        } else {
            JsonUtil.processJsonKeyParsingFail(key);
        }
        boolean bl = isErrorLevel = minNestingLevel > maxNestingLevel || maxNestingLevel > configMaxNestingLevel;
        if (isErrorLevel) {
            JsonUtil.processJsonKeyParsingFail(key);
        }
        StringBuilder nestingKeyBuffer = new StringBuilder(16);
        for (int i = 0; i < minNestingLevel; ++i) {
            nestingKeyBuffer.append(nestingKeyName);
            nestingKeyBuffer.append('.');
        }
        info.setKeyPart1(key.substring(0, firstCharBracket));
        info.setKeyPart3(key.substring(lastCharBracket2 + 2));
        info.setMaxNestingLevel(maxNestingLevel);
        info.setMinNestingLevel(minNestingLevel);
        info.setNestingKeyBuffer(nestingKeyBuffer);
        info.setNestingKeyName(nestingKeyName);
        return info;
    }

    private static void invalidLevelCheck(String key, String[] arrayLevel) throws ValidateException {
        if (!pattern.matcher(arrayLevel[0]).matches()) {
            JsonUtil.processJsonKeyParsingFail(key);
        }
        if (arrayLevel.length > 1 && !pattern.matcher(arrayLevel[1]).matches()) {
            JsonUtil.processJsonKeyParsingFail(key);
        }
    }

    private static void processJsonKeyParsingFail(String key) throws ValidateException {
        LOG.error("[WSF-ParamValidate] Json key config error, key is {}.", (Object)LogUtils.cleanLog(key));
        throw new ValidateException("Json key config error, key is " + LogUtils.cleanLog(key));
    }

    public static class DetailInfo {
        private int minNestingLevel;
        private int maxNestingLevel;
        private String keyPart1;
        private String keyPart3;
        private StringBuilder nestingKeyBuffer;
        private String nestingKeyName;

        public int getMinNestingLevel() {
            return this.minNestingLevel;
        }

        public void setMinNestingLevel(int minNestingLevel) {
            this.minNestingLevel = minNestingLevel;
        }

        public int getMaxNestingLevel() {
            return this.maxNestingLevel;
        }

        public void setMaxNestingLevel(int maxNestingLevel) {
            this.maxNestingLevel = maxNestingLevel;
        }

        public String getKeyPart1() {
            return this.keyPart1;
        }

        public void setKeyPart1(String keyPart1) {
            this.keyPart1 = keyPart1;
        }

        public String getKeyPart3() {
            return this.keyPart3;
        }

        public void setKeyPart3(String keyPart3) {
            this.keyPart3 = keyPart3;
        }

        public StringBuilder getNestingKeyBuffer() {
            return this.nestingKeyBuffer;
        }

        public void setNestingKeyBuffer(StringBuilder nestingKeyBuffer) {
            this.nestingKeyBuffer = nestingKeyBuffer;
        }

        public String getNestingKeyName() {
            return this.nestingKeyName;
        }

        public void setNestingKeyName(String nestingKeyName) {
            this.nestingKeyName = nestingKeyName;
        }
    }
}

