/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.JsonParseInterface;
import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.JsonProcessUtils;
import com.huawei.security.validator.util.jsonflattener.orgjson.JsonArray;
import com.huawei.security.validator.util.jsonflattener.orgjson.JsonObject;
import com.huawei.security.validator.util.jsonflattener.orgjson.JsonValue;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public final class OrgJsonPerformanceProcess
implements JsonParseInterface {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public Object getJsonObject(String jsonStr) throws ParseRequestDataException {
        if (EmptyUtils.isEmpty(jsonStr)) {
            LOG.error("[WSF-ParamValidate] The OrgJSONObject String for converting to OrgJson is Empty.");
            throw new ParseRequestDataException("OrgJson Failed to parse OrgJSONObject String.");
        }
        try {
            String orgJsonObjectStr = jsonStr.trim();
            if (orgJsonObjectStr.startsWith("[")) {
                return new JsonValue(new JSONArray(jsonStr));
            }
            if (orgJsonObjectStr.startsWith("{")) {
                return new JsonValue(new JSONObject(jsonStr));
            }
            LOG.error("[WSF-ParamValidate] The OrgJSONObject String has not correct Json struct: Json check.");
            throw new ParseRequestDataException("Json parse json occur exception.");
        }
        catch (JSONException e) {
            LOG.error("[WSF-ParamValidate] The OrgJSONObject String has not correct Json struct: Json check.");
            throw new ParseRequestDataException("Json parse json occur exception.", e);
        }
        catch (Exception e) {
            LOG.error("[WSF-ParamValidate] Traverse json data occur exception.");
            throw new ParseRequestDataException("OrgJson failed to parse JSONObject Sting.", e);
        }
    }

    @Override
    public void traverseJsonData(Object json, Map<String, List<String>> dataMap, String completeKey) throws ParseRequestDataException {
        if (!(json instanceof JsonValue)) {
            throw new ParseRequestDataException("OrgJson Object not instance JsonValue.");
        }
        JsonBaseCore source = (JsonBaseCore)json;
        JsonProcessUtils.jsonTraverse(dataMap, source);
    }

    @Override
    public boolean isEmptyJson(Object orgJson) throws ParseRequestDataException {
        if (orgJson == null) {
            throw new ParseRequestDataException("orgJson content is null.");
        }
        if (orgJson instanceof JsonValue) {
            JsonValue orgJsonValue = (JsonValue)orgJson;
            if (orgJsonValue.isArray()) {
                JsonArray orgJsonArray = orgJsonValue.asArray();
                return orgJsonArray.isEmpty();
            }
            if (orgJsonValue.isObject()) {
                JsonObject orgJsonObject = orgJsonValue.asObject();
                return orgJsonObject.isEmpty();
            }
        }
        LOG.error("[WSF-ParamValidate] The orgJson input object is not belong to Json.");
        return false;
    }
}

