/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.config.FileCache;
import com.huawei.security.validator.exception.ParseRequestDataException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.DOMWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PathUtil {
    public static String getFullXPath(Node currentNode) {
        Node node;
        Node parent;
        Stack<Node> nodeStack = new Stack<Node>();
        StringBuilder xpathBuffer = new StringBuilder();
        nodeStack.push(currentNode);
        switch (currentNode.getNodeType()) {
            case 2: {
                parent = ((Attr)currentNode).getOwnerElement();
                break;
            }
            case 1: 
            case 9: {
                parent = currentNode.getParentNode();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected Node type" + currentNode.getNodeType());
            }
        }
        while (parent != null && parent.getNodeType() != 9) {
            nodeStack.push(parent);
            parent = parent.getParentNode();
        }
        while (!nodeStack.isEmpty() && (node = (Node)nodeStack.pop()) != null) {
            if (node.getNodeType() == 1) {
                xpathBuffer.append("/").append(PathUtil.getLocalNameWithNS(node.getNodeName()));
            }
            if (node.getNodeType() != 2) continue;
            xpathBuffer.append("/@");
            xpathBuffer.append(PathUtil.getLocalNameWithNS(node.getNodeName()));
        }
        return xpathBuffer.toString();
    }

    public static Map<String, String> getNameSpaces(Document doc) {
        HashMap<String, String> map = new HashMap<String, String>();
        Element rootElement = doc.getRootElement();
        for (Namespace declaredNamespace : rootElement.declaredNamespaces()) {
            String prefix = declaredNamespace.getPrefix();
            String uri = declaredNamespace.getURI();
            map.put(prefix, uri);
        }
        return map;
    }

    public static boolean elements(NodeList childNodes) {
        for (int j = 0; j < childNodes.getLength(); ++j) {
            if (childNodes.item(j).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static String getLocalNameWithNS(String qualifiedName) {
        boolean isPermit = "permit".equals(FileCache.getInstance().getCommonConfigsBean().getXmlEntity());
        if (isPermit) {
            return qualifiedName;
        }
        int index = qualifiedName.indexOf(":");
        String localName = index > 0 ? qualifiedName.substring(index + 1) : qualifiedName;
        return localName;
    }

    public static Optional<org.w3c.dom.Document> parse(Document doc) throws ParseRequestDataException {
        if (doc == null) {
            return Optional.empty();
        }
        try {
            DOMWriter d4print = new DOMWriter();
            org.w3c.dom.Document document = d4print.write(doc);
            return Optional.of(document);
        }
        catch (DocumentException e) {
            throw new ParseRequestDataException("Parse xml document exception failed.");
        }
    }

    public static String getFirstTextContent(Node node) {
        NodeList childList = node.getChildNodes();
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            if (child.getNodeType() != 3) continue;
            content.append(child.getTextContent());
        }
        return content.toString();
    }
}

