/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.log.WSFValidatorLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;

public final class StreamUtil {
    private static final int BUFFER = 512;
    private static final Logger LOG = WSFValidatorLog.getLogger();

    private StreamUtil() {
    }

    public static byte[] readBytes(InputStream input, long byteCount) throws IOException, ParseRequestDataException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        StreamUtil.copy(input, output, byteCount);
        return output.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream input, OutputStream output, long byteCount) throws IOException, ParseRequestDataException {
        if (input == null || output == null) {
            LOG.error("[WSF-ParamValidate] The InputStream or OutputStream is null.");
            throw new ParseRequestDataException("The InputStream or OutputStream is null.");
        }
        byte[] buffer = new byte[512];
        int count = 0;
        int totalSize = 0;
        try {
            while ((count = input.read(buffer, 0, 512)) != -1) {
                if ((long)(totalSize += count) > byteCount) {
                    LOG.error("[WSF-ParamValidate] InputStream size is lager than maxsize of config.");
                    throw new ParseRequestDataException("InputStream size is lager than maxsize of config.");
                }
                output.write(buffer, 0, count);
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException ex) {
                LOG.error("[WSF-ParamValidate] Close inputStream error.");
            }
            try {
                output.close();
            }
            catch (IOException ex) {
                LOG.error("[WSF-ParamValidate] Close outputStream error.");
            }
        }
        return totalSize;
    }
}

