/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.huawei.security.validator.util.jackson.JSONArray;
import java.io.IOException;
import java.util.Collection;

public class CustomSerializerProvider
extends DefaultSerializerProvider {
    private static final long serialVersionUID = 8134089332517831285L;

    public CustomSerializerProvider() {
    }

    public CustomSerializerProvider(CustomSerializerProvider provider, SerializationConfig cfg, SerializerFactory sf) {
        super((SerializerProvider)provider, cfg, sf);
    }

    public DefaultSerializerProvider createInstance(SerializationConfig cfg, SerializerFactory sf) {
        return new CustomSerializerProvider(this, cfg, sf);
    }

    public JsonSerializer<Object> findNullValueSerializer(BeanProperty property) throws JsonMappingException {
        Class clazz = property.getType().getRawClass();
        if (this.isString(clazz)) {
            return new EmptyStringSerializer<Object>();
        }
        if (this.isArray(clazz)) {
            return new EmptyArraySerializer<Object>();
        }
        if (this.isNumber(clazz)) {
            if (this.isDouble(clazz)) {
                return new EmptyDoubleSerializer<Object>();
            }
            return new EmptyIntSerializer<Object>();
        }
        if (this.isBoolean(clazz)) {
            return new EmptyBooleanSerializer<Object>();
        }
        return super.findNullValueSerializer(property);
    }

    private boolean isArray(Class<?> clazz) {
        return clazz != null && (clazz.isArray() || Collection.class.isAssignableFrom(clazz) || JSONArray.class.isAssignableFrom(clazz));
    }

    private boolean isString(Class<?> clazz) {
        return clazz != null && (String.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz));
    }

    private boolean isNumber(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (Byte.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return true;
        }
        return Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz);
    }

    private boolean isDouble(Class<?> clazz) {
        return clazz != null && (Double.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz));
    }

    private boolean isBoolean(Class<?> clazz) {
        return clazz != null && (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz));
    }

    private static class EmptyDoubleSerializer<T>
    extends JsonSerializer<T> {
        private EmptyDoubleSerializer() {
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeNumber(0.0);
        }
    }

    private static class EmptyIntSerializer<T>
    extends JsonSerializer<T> {
        private EmptyIntSerializer() {
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeNumber(0);
        }
    }

    private static class EmptyArraySerializer<T>
    extends JsonSerializer<T> {
        private EmptyArraySerializer() {
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeObject((Object)new JSONArray());
        }
    }

    private static class EmptyBooleanSerializer<T>
    extends JsonSerializer<T> {
        private EmptyBooleanSerializer() {
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeBoolean(false);
        }
    }

    private static class EmptyStringSerializer<T>
    extends JsonSerializer<T> {
        private EmptyStringSerializer() {
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString("");
        }
    }
}

