/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jsonflattener.fastjson;

import com.alibaba.fastjson.JSONArray;
import com.huawei.security.validator.util.jsonflattener.JsonArrayCore;
import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.fastjson.JsonObject;
import com.huawei.security.validator.util.jsonflattener.fastjson.JsonValue;
import java.util.Iterator;
import java.util.Objects;

public final class JsonArray
implements JsonArrayCore<JsonValue> {
    private final JSONArray fastJsonArray;

    public JsonArray(Object jsonArray) {
        if (!(jsonArray instanceof JSONArray)) {
            throw new UnsupportedOperationException();
        }
        this.fastJsonArray = (JSONArray)jsonArray;
    }

    @Override
    public JsonValue get(int index) {
        return new JsonValue(this.fastJsonArray.get(index));
    }

    public int hashCode() {
        return this.fastJsonArray.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonArray)) {
            return false;
        }
        return Objects.equals(this.fastJsonArray, ((JsonArray)obj).fastJsonArray);
    }

    @Override
    public boolean isObject() {
        return false;
    }

    public String toString() {
        return this.fastJsonArray.toString();
    }

    public JsonArray asArray() {
        return this;
    }

    @Override
    public Iterator<JsonValue> iterator() {
        return new FastJsonJsonValueIterator(this.fastJsonArray.iterator());
    }

    @Override
    public void add(JsonBaseCore jsonValue) {
        this.fastJsonArray.add(jsonValue.getSource());
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public void set(int index, JsonBaseCore jsonValue) {
        this.fastJsonArray.set(index, jsonValue.getSource());
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(int index) {
        return this.fastJsonArray.remove(index) != null;
    }

    public JsonObject asObject() {
        throw new UnsupportedOperationException();
    }

    public JsonValue asValue() {
        return new JsonValue(this.fastJsonArray);
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public Object getSource() {
        return this.fastJsonArray;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public int size() {
        return this.fastJsonArray.size();
    }

    private static class FastJsonJsonValueIterator
    implements Iterator<JsonValue> {
        private final Iterator<Object> fastJsonValueIterator;

        private FastJsonJsonValueIterator(Iterator<Object> jsonValueIterator) {
            this.fastJsonValueIterator = jsonValueIterator;
        }

        @Override
        public boolean hasNext() {
            return this.fastJsonValueIterator.hasNext();
        }

        @Override
        public JsonValue next() {
            return new JsonValue(this.fastJsonValueIterator.next());
        }
    }
}

