/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jsonflattener.fastjson;

import com.alibaba.fastjson.JSONObject;
import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.JsonObjectCore;
import com.huawei.security.validator.util.jsonflattener.fastjson.JsonArray;
import com.huawei.security.validator.util.jsonflattener.fastjson.JsonValue;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class JsonObject
implements JsonObjectCore<JsonValue> {
    private final JSONObject fastJsonObject;

    public JsonObject(JSONObject jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException();
        }
        this.fastJsonObject = jsonObject;
    }

    @Override
    public Optional<JsonBaseCore<?>> get(String name) {
        Object node = this.fastJsonObject.get(name);
        return node == null ? Optional.empty() : Optional.of(new JsonValue(node));
    }

    public int hashCode() {
        return this.fastJsonObject.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonObject)) {
            return false;
        }
        return Objects.equals(this.fastJsonObject, ((JsonObject)obj).fastJsonObject);
    }

    public String toString() {
        return this.fastJsonObject.toString();
    }

    @Override
    public Iterator<Map.Entry<String, JsonValue>> iterator() {
        return new FastJsonJsonEntryIterator(this.fastJsonObject.entrySet().iterator());
    }

    @Override
    public int size() {
        return this.fastJsonObject.size();
    }

    @Override
    public void set(String name, JsonBaseCore jsonValue) {
        this.fastJsonObject.put(name, jsonValue.getSource());
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean remove(String name) {
        return this.fastJsonObject.remove(name) != null;
    }

    @Override
    public boolean contains(String name) {
        return this.fastJsonObject.containsKey(name);
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    public JsonValue asValue() {
        return new JsonValue(this.fastJsonObject);
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    public JsonArray asArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getSource() {
        return this.fastJsonObject;
    }

    @Override
    public Iterator<String> names() {
        return this.fastJsonObject.keySet().iterator();
    }

    public JsonObject asObject() {
        return this;
    }

    private static class FastJsonJsonEntryIterator
    implements Iterator<Map.Entry<String, JsonValue>> {
        private final Iterator<Map.Entry<String, Object>> fastJsonNodeIterator;

        private FastJsonJsonEntryIterator(Iterator<Map.Entry<String, Object>> jsonNodeIterator) {
            this.fastJsonNodeIterator = jsonNodeIterator;
        }

        @Override
        public boolean hasNext() {
            return this.fastJsonNodeIterator.hasNext();
        }

        @Override
        public Map.Entry<String, JsonValue> next() {
            Map.Entry<String, Object> member = this.fastJsonNodeIterator.next();
            return new AbstractMap.SimpleImmutableEntry<String, JsonValue>(member.getKey(), new JsonValue(member.getValue()));
        }
    }
}

