/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jsonflattener.gson;

import com.google.gson.JsonElement;
import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.JsonObjectCore;
import com.huawei.security.validator.util.jsonflattener.gson.JsonArray;
import com.huawei.security.validator.util.jsonflattener.gson.JsonValue;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class JsonObject
implements JsonObjectCore<JsonValue> {
    private final com.google.gson.JsonObject gsonObject;

    public JsonObject(com.google.gson.JsonObject jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException();
        }
        this.gsonObject = jsonObject;
    }

    @Override
    public Optional<JsonBaseCore<?>> get(String name) {
        JsonElement element = this.gsonObject.get(name);
        return element == null ? Optional.empty() : Optional.of(new JsonValue(element));
    }

    public int hashCode() {
        return this.gsonObject.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonObject)) {
            return false;
        }
        return Objects.equals(this.gsonObject, ((JsonObject)obj).gsonObject);
    }

    public String toString() {
        return this.gsonObject.toString();
    }

    @Override
    public Iterator<Map.Entry<String, JsonValue>> iterator() {
        Set entries = this.gsonObject.entrySet();
        return new GsonJsonEntryIterator(entries.iterator());
    }

    @Override
    public int size() {
        return this.gsonObject.size();
    }

    @Override
    public void set(String name, JsonBaseCore jsonValue) {
        Object source = jsonValue.getSource();
        if (!(source instanceof JsonElement)) {
            throw new UnsupportedOperationException();
        }
        this.gsonObject.add(name, (JsonElement)source);
    }

    @Override
    public boolean remove(String name) {
        return this.gsonObject.remove(name) != null;
    }

    @Override
    public boolean contains(String name) {
        return this.gsonObject.has(name);
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public JsonArray asArray() {
        throw new UnsupportedOperationException();
    }

    public JsonValue asValue() {
        return new JsonValue((JsonElement)this.gsonObject);
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    public JsonObject asObject() {
        return this;
    }

    @Override
    public Object getSource() {
        return this.gsonObject;
    }

    @Override
    public Iterator<String> names() {
        return this.gsonObject.keySet().iterator();
    }

    private static class GsonJsonEntryIterator
    implements Iterator<Map.Entry<String, JsonValue>> {
        private final Iterator<Map.Entry<String, JsonElement>> jsonElementIterator;

        private GsonJsonEntryIterator(Iterator<Map.Entry<String, JsonElement>> jsonElementIterator) {
            this.jsonElementIterator = jsonElementIterator;
        }

        @Override
        public boolean hasNext() {
            return this.jsonElementIterator.hasNext();
        }

        @Override
        public Map.Entry<String, JsonValue> next() {
            Map.Entry<String, JsonElement> member = this.jsonElementIterator.next();
            return new AbstractMap.SimpleImmutableEntry<String, JsonValue>(member.getKey(), new JsonValue(member.getValue()));
        }
    }
}

