/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jsonflattener.orgjson;

import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.JsonObjectCore;
import com.huawei.security.validator.util.jsonflattener.orgjson.JsonArray;
import com.huawei.security.validator.util.jsonflattener.orgjson.JsonValue;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class JsonObject
implements JsonObjectCore<JsonValue> {
    private final Map<String, Object> orgJsonObject;

    public JsonObject(Map<String, Object> jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException();
        }
        this.orgJsonObject = jsonObject;
    }

    @Override
    public Optional<JsonBaseCore<?>> get(String name) {
        Object node = this.orgJsonObject.get(name);
        return node == null ? Optional.empty() : Optional.of(new JsonValue(node));
    }

    public int hashCode() {
        return this.orgJsonObject.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonObject)) {
            return false;
        }
        return Objects.equals(this.orgJsonObject, ((JsonObject)obj).orgJsonObject);
    }

    public String toString() {
        return this.orgJsonObject.toString();
    }

    @Override
    public Iterator<Map.Entry<String, JsonValue>> iterator() {
        return new OrgJsonJsonEntryIterator(this.orgJsonObject.entrySet().iterator());
    }

    @Override
    public int size() {
        return this.orgJsonObject.size();
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public void set(String name, JsonBaseCore<? extends JsonBaseCore<?>> jsonValue) {
        this.orgJsonObject.put(name, jsonValue.getSource());
    }

    @Override
    public boolean isString() {
        return false;
    }

    public JsonObject asObject() {
        return this;
    }

    @Override
    public boolean remove(String name) {
        return this.orgJsonObject.remove(name) != null;
    }

    @Override
    public boolean contains(String name) {
        return this.orgJsonObject.containsKey(name);
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public Object getSource() {
        return this.orgJsonObject;
    }

    public JsonArray asArray() {
        throw new UnsupportedOperationException();
    }

    public JsonValue asValue() {
        return new JsonValue(this.orgJsonObject);
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<String> names() {
        return this.orgJsonObject.keySet().iterator();
    }

    private static class OrgJsonJsonEntryIterator
    implements Iterator<Map.Entry<String, JsonValue>> {
        private final Iterator<Map.Entry<String, Object>> orgJsonNodeIterator;

        private OrgJsonJsonEntryIterator(Iterator<Map.Entry<String, Object>> jsonNodeIterator) {
            this.orgJsonNodeIterator = jsonNodeIterator;
        }

        @Override
        public boolean hasNext() {
            return this.orgJsonNodeIterator.hasNext();
        }

        @Override
        public Map.Entry<String, JsonValue> next() {
            Map.Entry<String, Object> member = this.orgJsonNodeIterator.next();
            return new AbstractMap.SimpleImmutableEntry<String, JsonValue>(member.getKey(), new JsonValue(member.getValue()));
        }
    }
}

