/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util.jsonflattener.orgjson;

import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.orgjson.JsonArray;
import com.huawei.security.validator.util.jsonflattener.orgjson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public final class JsonValue
implements JsonBaseCore<JsonValue> {
    private final Object orgJsonValue;

    public JsonValue(Object jsonValue) {
        this.orgJsonValue = jsonValue;
    }

    @Override
    public boolean isObject() {
        return this.orgJsonValue instanceof JSONObject || this.orgJsonValue instanceof Map;
    }

    @Override
    public boolean isArray() {
        return this.orgJsonValue instanceof List || this.orgJsonValue instanceof JSONArray;
    }

    @Override
    public boolean isString() {
        return !(this.orgJsonValue instanceof Map) && !(this.orgJsonValue instanceof List);
    }

    public JsonObject asObject() {
        if (this.orgJsonValue instanceof JSONObject) {
            JSONObject orgJsonValueTemp = (JSONObject)this.orgJsonValue;
            return new JsonObject(orgJsonValueTemp.toMap());
        }
        return new JsonObject((Map)this.orgJsonValue);
    }

    public JsonArray asArray() {
        if (this.orgJsonValue instanceof JSONArray) {
            JSONArray orgJsonValueTemp = (JSONArray)this.orgJsonValue;
            return new JsonArray(orgJsonValueTemp.toList());
        }
        return new JsonArray((List)this.orgJsonValue);
    }

    public JsonValue asValue() {
        return this;
    }

    @Override
    public String asString() {
        return this.orgJsonValue.toString();
    }

    @Override
    public boolean isNull() {
        return this.orgJsonValue == null;
    }

    public int hashCode() {
        return this.orgJsonValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonValue)) {
            return false;
        }
        return Objects.equals(this.orgJsonValue, ((JsonValue)obj).orgJsonValue);
    }

    public String toString() {
        return this.orgJsonValue.toString();
    }

    @Override
    public Object getSource() {
        return this.orgJsonValue;
    }
}

