/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.RegExpExecutor;
import com.huawei.security.validator.util.ValidatorUtil;
import java.util.HashMap;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;

public class BlackValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        ValidatorResult result = new ValidatorResult(true);
        String errorCode = ValidatorEnum.BLACK_VALIDATOR.name();
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] Input validate parameter value is null, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, errorCode, new Object[0]);
            return result;
        }
        if (validateRuleMap == null || validateRuleMap.get("rule") == null) {
            LOG.error("[WSF-ParamValidate] BlackValidator:attribute rule config error, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, errorCode, new Object[0]);
            return result;
        }
        String expression = validateRuleMap.get("rule");
        try {
            boolean validateResult = RegExpExecutor.validate(expression, false, inputValidate, true);
            if (validateResult) {
                LOG.error("[WSF-ParamValidate] BLACK_VALIDATOR validate fail.");
                ValidatorUtil.setErrorResult(result, errorKey, errorMessage, errorCode, new Object[0]);
            }
        }
        catch (PatternSyntaxException ex) {
            LOG.error("[WSF-ParamValidate] The regexp for BlackValidator is wrong. wrong message: {}.", (Object)LogUtils.cleanLog(ex.getMessage()));
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        return result;
    }
}

