/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.RegExpExecutor;
import com.huawei.security.validator.util.ValidatorUtil;
import java.util.HashMap;
import org.slf4j.Logger;

public class CreditCardValidator
implements Validator {
    private static final String CREDIT_CARD_REGEXP = "[0-9]+";
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        ValidatorResult result = new ValidatorResult();
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] Input validate parameter value is null, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.CREADITCARD_VALIDATOR.name(), new Object[0]);
            return result;
        }
        if (!this.validateCreditCard(inputValidate)) {
            LOG.error("[WSF-ParamValidate] CREADITCARD_VALIDATOR validate fail.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, ValidatorEnum.CREADITCARD_VALIDATOR.name(), new Object[0]);
        }
        return result;
    }

    private <T> boolean validateCreditCard(T value) {
        boolean validateResult = RegExpExecutor.validate(CREDIT_CARD_REGEXP, true, value, false);
        if (!validateResult) {
            return false;
        }
        int nCheck = 0;
        boolean bEven = false;
        String creditCard = String.valueOf(value);
        creditCard = creditCard.replaceAll("\\D", "");
        for (int n = creditCard.length() - 1; n >= 0; --n) {
            int digitInt = Integer.parseInt(Character.toString(creditCard.charAt(n)));
            if (bEven && (digitInt *= 2) > 9) {
                digitInt -= 9;
            }
            nCheck += digitInt;
            bEven = !bEven;
        }
        return nCheck % 10 == 0;
    }
}

