/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.validators;

import com.huawei.security.validator.bean.ValidatorEnum;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.RegExpExecutor;
import com.huawei.security.validator.util.ValidatorUtil;
import java.util.HashMap;
import org.slf4j.Logger;

public class SQLValidator
implements Validator {
    private static final String SQL_COMMENT_SEQUENCES = "(/\\*!?|\\*/|[';]--|--[\\s\\r\\n\\v\\f]|(?:--[^-]*?-)|([^\\-&])#.*?[\\s\\r\\n\\v\\f]|;?\\x00)";
    private static final String SQL_HEX_EVASION = "(?i:(?:\\A|[^\\d])0x[a-f\\d]{3,}[a-f\\d]*)";
    private static final String STRING_TERMINATION_OR_STATEMENT_ENDING = "(^[\"'`\u2032\u2019\u2018;]+|[\"'`\u2032\u2019\u2018;]+$)";
    private static final String SQL_OPERATORS = "(?i:(\\!\\=|\\&\\&|\\|\\||>>|<<|>=|<=|<>|<=>|xor|rlike|regexp|isnull)|(?:not\\s+between\\s+0\\s+and)|(?:is\\s+null)|(like\\s+null)|(?:(?:^|\\W)in[+\\s]*\\([\\s\\d\"]+[^()]*\\))|(?:xor|<>|rlike(?:\\s+binary)?)|(?:regexp\\s+binary))";
    private static final String SQL_TAUTOLOGIES = "(?i:([\\s'\"`\u2032\u2019\u2018\\(\\)]*?)\\b([\\d\\w]++)([\\s'\"`\u2032\u2019\u2018\\(\\)]*?)(?:(?:=|<=>|r?like|sounds\\s+like|regexp)([\\s'\"`\u2032\u2019\u2018\\(\\)]*?)\u0002\\b|(?:!=|<=|>=|<>|<|>|\\^|is\\s+not|not\\s+like|not\\s+regexp)([\\s'\"`\u2032\u2019\u2018\\(\\)]*?)(?!\u0002)([\\d\\w]+)\\b))";
    private static final String DETECT_DB_NAMES = "(?i:(?:m(?:s(?:ysaccessobjects|ysaces|ysobjects|ysqueries|ysrelationships|ysaccessstorage|ysaccessxml|ysmodules|ysmodules2|db)|aster\\.\\.sysdatabases|ysql\\.db)|s(?:ys(?:\\.database_name|aux)|chema(?:\\W*\\(|_name)|qlite(_temp)?_master)|d(?:atabas|b_nam)e\\W*\\(|information_schema|pg_(catalog|toast)|northwind|tempdb))";
    private static final String[] RULE_ARRAY = new String[]{"(/\\*!?|\\*/|[';]--|--[\\s\\r\\n\\v\\f]|(?:--[^-]*?-)|([^\\-&])#.*?[\\s\\r\\n\\v\\f]|;?\\x00)", "(?i:(?:\\A|[^\\d])0x[a-f\\d]{3,}[a-f\\d]*)", "(^[\"'`\u2032\u2019\u2018;]+|[\"'`\u2032\u2019\u2018;]+$)", "(?i:(\\!\\=|\\&\\&|\\|\\||>>|<<|>=|<=|<>|<=>|xor|rlike|regexp|isnull)|(?:not\\s+between\\s+0\\s+and)|(?:is\\s+null)|(like\\s+null)|(?:(?:^|\\W)in[+\\s]*\\([\\s\\d\"]+[^()]*\\))|(?:xor|<>|rlike(?:\\s+binary)?)|(?:regexp\\s+binary))", "(?i:([\\s'\"`\u2032\u2019\u2018\\(\\)]*?)\\b([\\d\\w]++)([\\s'\"`\u2032\u2019\u2018\\(\\)]*?)(?:(?:=|<=>|r?like|sounds\\s+like|regexp)([\\s'\"`\u2032\u2019\u2018\\(\\)]*?)\u0002\\b|(?:!=|<=|>=|<>|<|>|\\^|is\\s+not|not\\s+like|not\\s+regexp)([\\s'\"`\u2032\u2019\u2018\\(\\)]*?)(?!\u0002)([\\d\\w]+)\\b))", "(?i:(?:m(?:s(?:ysaccessobjects|ysaces|ysobjects|ysqueries|ysrelationships|ysaccessstorage|ysaccessxml|ysmodules|ysmodules2|db)|aster\\.\\.sysdatabases|ysql\\.db)|s(?:ys(?:\\.database_name|aux)|chema(?:\\W*\\(|_name)|qlite(_temp)?_master)|d(?:atabas|b_nam)e\\W*\\(|information_schema|pg_(catalog|toast)|northwind|tempdb))"};
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        if (inputValidate == null) {
            LOG.error("[WSF-ParamValidate] Input validate parameter value is null, so the result is false.");
            String errorCode = ValidatorEnum.SQL_ATTACK_VALIDATOR.name();
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        for (String rule : RULE_ARRAY) {
            boolean validateResult = RegExpExecutor.validate(rule, false, inputValidate, true);
            if (!validateResult) continue;
            LOG.error("[WSF-ParamValidate] SQL_ATTACK_VALIDATOR validate fail.");
            String errorCode = ValidatorEnum.SQL_ATTACK_VALIDATOR.name();
            return ValidatorUtil.getResult(errorKey, errorMessage, errorCode, false, new Object[0]);
        }
        return new ValidatorResult(true);
    }
}

