/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.web;

import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.web.JsonChecker;

public class EmptyObjectJsonChecker
implements JsonChecker {
    @Override
    public boolean preCheck(String jsonStr, int maxObjSize) {
        if (EmptyUtils.isEmpty(jsonStr) || (long)jsonStr.length() < COMMON_CONFIG_BEAN.getMinJsonCheckLength()) {
            return true;
        }
        long jsonObjNums = 0L;
        jsonObjNums = this.countJsonObjSize(jsonStr);
        return maxObjSize == Integer.MIN_VALUE ? jsonObjNums <= (long)COMMON_CONFIG_BEAN.getJsonObjMaxSize() : jsonObjNums <= (long)maxObjSize;
    }

    private long countJsonObjSize(String jsonStr) {
        long count = 0L;
        String copyStr = jsonStr.replaceAll("\\s", "").replaceAll("\\\\\"", "").replaceAll("\".+?\"", "");
        int start = 0;
        while (start < copyStr.length() && start + 1 < copyStr.length()) {
            if (copyStr.charAt(start) == '{' && copyStr.charAt(start + 1) == '}') {
                ++count;
                start += 2;
                continue;
            }
            ++start;
        }
        return count;
    }
}

