/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.adapter.encryption.factory;

import com.huawei.support.icscbb.adapter.encryption.service.DataSecurity;
import com.huawei.support.icscbb.adapter.encryption.service.impl.DpapiDataSecurityHandler;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;

public class DataSecurityHandlerFactory {
    public static final String ENCRYPT_MODE_KMC = "KMC";
    public static final String ENCRYPT_MODE_DPAPI = "DPAPI";
    private static ConcurrentHashMap<String, DataSecurity> handlerMap = new ConcurrentHashMap();

    private DataSecurityHandlerFactory() {
    }

    private static void init() {
        DpapiDataSecurityHandler handler = DpapiDataSecurityHandler.getInstance();
        if (ObjectUtils.isNotEmpty(handler)) {
            handlerMap.put(ENCRYPT_MODE_DPAPI, handler);
        }
    }

    public static DataSecurity getInstance(String type) {
        return handlerMap.get(type);
    }

    static {
        DataSecurityHandlerFactory.init();
    }
}

