/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.adapter.storage.adapter;

import com.huawei.support.cbb.util.configuration.KVConfiguration;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NasManager {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(NasManager.class);
    private static String currentNasPath;
    private static String backupNasPath;
    @Value(value="${consul_nas_path}")
    private String consul_nas_path;

    public static String getCurrentNasPath() {
        return currentNasPath;
    }

    private static void setCurrentNasPath(String path) {
        currentNasPath = path;
    }

    public static String getBackupNasPath() {
        return backupNasPath;
    }

    private static void setBackupNasPath(String nasBackupPath) {
        backupNasPath = nasBackupPath;
    }

    @PostConstruct
    public void initNasManager() {
        String nasPath = KVConfiguration.getValue((String)this.consul_nas_path);
        if (StringUtils.isBlank(nasPath)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "can't get " + this.consul_nas_path + " from consul center");
            return;
        }
        nasPath = nasPath.trim();
        NasManager.setCurrentNasPath(nasPath);
        String nasBackupPath = KVConfiguration.getValue((String)"ics/ics.gray.nas.backup.path");
        if (StringUtils.isBlank(nasBackupPath)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "can't get ics/ics.gray.nas.backup.path from consul center");
            return;
        }
        nasBackupPath = nasBackupPath.trim();
        NasManager.setBackupNasPath(nasBackupPath);
    }
}

