/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.adapter.storage.service.impl;

import com.huawei.support.basicconfigservice.helper.SysconfigHelper;
import com.huawei.support.cbb.util.uuid.UUIDUtils;
import com.huawei.support.icscbb.adapter.storage.adapter.NasManager;
import com.huawei.support.icscbb.adapter.storage.service.StorageService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.zipfile.ZipFileUtils;
import com.huawei.support.synccephservice.service.SyncCephService;
import com.huawei.tools.commonlib.exception.ServiceException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StorageServiceImpl
implements StorageService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(StorageServiceImpl.class);
    private static final int MAX_SINGLE_FILE_SIZE = 0x40000000;
    private static final String ILLEGAL_CHAR = "..";
    private static final Pattern KEY_PATH = Pattern.compile("^resources(\\/|\\\\)infocenter_service(\\/|\\\\).+");
    @Autowired
    private SyncCephService syncCephService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeFile(String model, String filePathArg, InputStream inputStream) {
        if (StringUtils.isAnyBlank(model, filePathArg) || inputStream == null || StringUtils.contains((CharSequence)filePathArg, ILLEGAL_CHAR)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "illegal parameter or Illegal filePathArg");
            return "";
        }
        String filePath = FilenameUtils.normalize(filePathArg);
        String wholePath = this.makeWholePath(model, filePath = this.replaceAllIllegalCharactor(filePath));
        if (StringUtils.isBlank(wholePath)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "wholePath fail");
            return "";
        }
        try {
            File file = FileUtils.getFile(wholePath);
            FileUtils.copyInputStreamToFile(inputStream, file);
            this.backupData(file.getCanonicalPath(), "add");
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "nas write failed, filePath = " + wholePath, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
        return wholePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String writeFile(String model, String filePathArg, String readFilePathArg) {
        String string;
        if (StringUtils.isAnyBlank(model, filePathArg, readFilePathArg)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Illegal parameter");
        }
        if (StringUtils.contains((CharSequence)filePathArg, ILLEGAL_CHAR)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal filePathArg");
            return "";
        }
        String filePath = FilenameUtils.normalize(filePathArg);
        filePath = this.replaceAllIllegalCharactor(filePath);
        if (StringUtils.contains((CharSequence)readFilePathArg, ILLEGAL_CHAR)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal readFilePathArg");
            return "";
        }
        String readFilePath = FilenameUtils.normalize(readFilePathArg);
        if (!IcsFileUtils.isInSecureDir(readFilePath)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "realdFilePath is not in secure directory.");
            return "";
        }
        if (!this.isFileExits(readFilePath)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "no such file");
            return "";
        }
        FileInputStream openInputStream = null;
        try {
            openInputStream = FileUtils.openInputStream(FileUtils.getFile(readFilePath));
            string = this.writeFile(model, filePath, openInputStream);
        }
        catch (IOException e) {
            try {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal readFilePath");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(openInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)openInputStream);
            return "";
        }
        IOUtils.closeQuietly((Closeable)openInputStream);
        return string;
    }

    @Override
    public void backupData(String filePath, String operationType) {
        if (StringUtils.isAnyBlank(filePath, operationType)) {
            return;
        }
        try {
            String nasWriteSwitch = SysconfigHelper.getStringValueWithCache((String)"ics.web.nas.write.switch");
            if (!StringUtils.equals(nasWriteSwitch, "on")) {
                return;
            }
            String masterMountPoint = NasManager.getCurrentNasPath();
            String slaveMountPoint = NasManager.getBackupNasPath();
            if (StringUtils.isAnyBlank(masterMountPoint, slaveMountPoint)) {
                return;
            }
            String canonicalPath = FileUtils.getFile(filePath).getCanonicalPath();
            if (this.syncCephService.syncNasByMountPointInfo(canonicalPath, masterMountPoint, slaveMountPoint, operationType).booleanValue()) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "backupnas success.");
            }
        }
        catch (ServiceException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "backupnas failed.");
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "getCanonicalPath or backupnas failed.");
        }
    }

    @Override
    public InputStream readFile(String filePathArg) {
        if (StringUtils.isBlank(filePathArg) || StringUtils.contains((CharSequence)filePathArg, ILLEGAL_CHAR)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Illegal filePathArg", (Throwable)new Exception("Illegal filePathArg"));
            return null;
        }
        String filePath = FilenameUtils.normalize(filePathArg);
        if (!IcsFileUtils.isInSecureDir(filePath)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "illegal readFilePath");
            return null;
        }
        if (!this.isFileExits(filePath)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "the file dos't exits;");
            return null;
        }
        File file = FileUtils.getFile(filePath);
        try {
            return FileUtils.openInputStream(file);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "get inputstream fail");
            return null;
        }
    }

    @Override
    public InputStream readFileFromZip(ZipFile zipFile, String inZipPath) {
        if (zipFile == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal zipFile parameter");
            return null;
        }
        if (StringUtils.isBlank(inZipPath) || StringUtils.contains((CharSequence)inZipPath, ILLEGAL_CHAR)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal inZipPath");
            return null;
        }
        String inZipPathNormalize = FilenameUtils.normalize(inZipPath);
        InputStream input = ZipFileUtils.getInput(zipFile, inZipPathNormalize);
        if (input == null) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "inZipPath:" + inZipPathNormalize);
            CodeCCUtils.INSTANCE.errorLog(LOG, "can't get InputStream;");
            return null;
        }
        return new BufferedInputStream(input);
    }

    @Override
    public InputStream readFileFromJdkZip(java.util.zip.ZipFile zipFile, String inZipPath) {
        if (zipFile == null) {
            return null;
        }
        if (StringUtils.isBlank(inZipPath)) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(inZipPath.replaceAll("\\\\", "/"));
        if (entry == null) {
            return null;
        }
        try {
            InputStream input = zipFile.getInputStream(entry);
            if (input == null) {
                return null;
            }
            return new BufferedInputStream(input);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Failed to get file inputstream.");
            return null;
        }
    }

    @Override
    public InputStream readFileFromHwics(String hdxfFileInfo, ZipFile zipFile, String inZipPath, boolean multiRecord) {
        if (zipFile == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal Hwics zipFile parameter");
            return null;
        }
        if (StringUtils.isBlank(inZipPath) || StringUtils.contains((CharSequence)inZipPath, ILLEGAL_CHAR)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal inZipPath");
            return null;
        }
        String inZipPathNormalize = FilenameUtils.normalize(inZipPath);
        ZipArchiveEntry entry = ZipFileUtils.getZipEntry(zipFile, inZipPathNormalize);
        if (entry == null && (entry = ZipFileUtils.getZipEntry(zipFile, inZipPathNormalize.toLowerCase(Locale.ENGLISH))) == null) {
            return null;
        }
        if (this.checkFileSize(hdxfFileInfo, inZipPathNormalize, zipFile, entry, multiRecord)) {
            return null;
        }
        try {
            return zipFile.getInputStream(entry);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "StorageService zipFile.getInputStream IO error.");
            return null;
        }
    }

    @Override
    public InputStream readFileFromHwicsSafely(String hdxfFileInfo, ZipFile zipFile, String inZipPath, boolean multiRecord) {
        Matcher matcher;
        if (StringUtils.isBlank(inZipPath) || StringUtils.contains((CharSequence)inZipPath, ILLEGAL_CHAR)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal inZipPath");
            return null;
        }
        String inZipPathNormalize = FilenameUtils.normalize(inZipPath);
        if (this.isIllegalPath(inZipPathNormalize, matcher = KEY_PATH.matcher(inZipPathNormalize))) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal inZipPath;{}" + inZipPathNormalize);
            CodeCCUtils.INSTANCE.infoLog(LOG, "should not start with " + KEY_PATH.pattern());
            return null;
        }
        return this.readFileFromHwics(hdxfFileInfo, zipFile, inZipPathNormalize, multiRecord);
    }

    private boolean isIllegalPath(String inZipPath, Matcher matcher) {
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        return !isWindows && StringUtils.contains((CharSequence)inZipPath, ILLEGAL_CHAR) && matcher.find();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTooLarge(ZipFile zipFile, ZipArchiveEntry entry) {
        int size = 0;
        byte[] buffer = new byte[1024];
        try (BufferedInputStream inputStream = new BufferedInputStream(zipFile.getInputStream(entry));){
            int readBytes;
            do {
                if ((readBytes = inputStream.read(buffer, 0, buffer.length)) == -1) return false;
            } while ((size += readBytes) <= 0x40000000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "read single file failure");
            return true;
        }
    }

    private boolean checkFileSize(String hdxFileInfo, String inZipPath, ZipFile zipFile, ZipArchiveEntry entry, boolean multiRecord) {
        if (this.isTooLarge(zipFile, entry)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The single file is too big, hdxFileInfo is " + hdxFileInfo + ", inZipPath is " + inZipPath + ", multiRecord is " + multiRecord);
            return true;
        }
        return false;
    }

    @Override
    public boolean delFile(String filePathArg) {
        if (StringUtils.isBlank(filePathArg) || StringUtils.contains((CharSequence)filePathArg, ILLEGAL_CHAR)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal filePathArg");
            return false;
        }
        String filePath = FilenameUtils.normalize(filePathArg);
        if (!IcsFileUtils.isInSecureDir(filePath)) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "Illegal filepath");
            return false;
        }
        if (!FileUtils.getFile(filePath).exists()) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "the file dos't exits;");
            return false;
        }
        boolean isSuccess = FileUtils.deleteQuietly(FileUtils.getFile(filePath));
        if (isSuccess) {
            this.backupData(filePath, "delete");
        }
        return isSuccess;
    }

    private boolean isFileExits(String filePath) {
        File file = FileUtils.getFile(filePath);
        return !file.isDirectory() && IcsFileUtils.isExist(filePath);
    }

    private String makeWholePath(String model, String filePath) {
        String nasRootPath = NasManager.getCurrentNasPath();
        StringBuffer wholePath = new StringBuffer();
        wholePath.append(nasRootPath).append(File.separator).append(model);
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
        if (fileName.lastIndexOf(".") == -1) {
            fileName = UUIDUtils.getUUID();
        } else {
            String fileExtention = fileName.substring(fileName.lastIndexOf(".") + 1);
            fileName = UUIDUtils.getUUID() + "." + fileExtention;
        }
        String tempFilePath = filePath.substring(0, filePath.lastIndexOf(File.separator) + 1) + fileName;
        wholePath.append(tempFilePath);
        return wholePath.toString();
    }

    private String replaceAllIllegalCharactor(String filePath) {
        return filePath.replaceAll("[^\\w\\\\/\\-_~:\\u4e00-\\u9fa5#\\.,\\(\\)\\[\\]\\{\\}\\$\\%\\&@\\^'+;]", "#");
    }

    @Override
    public ZipFile getZipFile(String filePath) throws IOException {
        if (StringUtils.isBlank(filePath) || StringUtils.contains((CharSequence)filePath, ILLEGAL_CHAR)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal filePath");
            return null;
        }
        String normalize = FilenameUtils.normalize(filePath);
        if (!IcsFileUtils.isInSecureDir(normalize)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal filePath");
            return null;
        }
        File file = FileUtils.getFile(filePath);
        if (file == null || !file.exists()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create zipfile does not exist");
            return null;
        }
        return new ZipFile(file, "GBK");
    }

    @Override
    public java.util.zip.ZipFile getJdkZipFile(String filePath) throws IOException {
        java.util.zip.ZipFile zipFile = null;
        if (StringUtils.isBlank(filePath) || StringUtils.contains((CharSequence)filePath, ILLEGAL_CHAR)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal filePath");
            return zipFile;
        }
        String normalize = FilenameUtils.normalize(filePath);
        if (!IcsFileUtils.isInSecureDir(normalize)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal filePath");
            return null;
        }
        File file = FileUtils.getFile(filePath);
        if (file == null || !file.exists()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create zipfile does not exist");
            return null;
        }
        return new java.util.zip.ZipFile(file, Charset.forName("GBK"));
    }

    @Override
    public void closeZipFileQuietly(ZipFile zipFile) {
        if (zipFile == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "zipFile object is empty");
        }
        ZipFile.closeQuietly((ZipFile)zipFile);
    }
}

