/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.log.web.impl;

import com.huawei.support.basicconfigservice.helper.SysconfigSpringContextHelper;
import com.huawei.support.cbb.util.security.LoggerUtils;
import com.huawei.support.icscbb.log.common.util.LogUtils;
import com.huawei.support.icscbb.log.common.util.MethodStackUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.operationlogservice.client.handler.OperationLogUtils;
import com.huawei.support.operationlogservice.model.OperationLog;
import com.huawei.support.operationlogservice.service.OperationLogService;
import com.huawei.tools.commonlib.exception.ServiceException;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLogUtilsImpl
implements com.huawei.support.icscbb.log.common.service.OperationLogUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationLogUtilsImpl.class);

    @Override
    public void failOperationLog(String module, String operationType, String description, Throwable throwable) {
        this.commonLog(module, operationType, "FAIL", description, throwable);
    }

    @Override
    public void failOperationLog(String module, String operationType, String description) {
        this.commonLog(module, operationType, "FAIL", description, null);
    }

    @Override
    public void failOperationLog(String module, String operationType, String description, Object ... objects) {
        if (objects == null) {
            LoggerUtils.errorLog((Logger)LOGGER, (String)"objects is empty", (Object[])new Object[0]);
            return;
        }
        OperationLog operationLog = LogUtils.getOperationLog(objects);
        Throwable throwable = LogUtils.getThrowable(objects);
        this.commonLog(throwable, operationType, operationLog);
        this.addOperationLog(operationLog);
    }

    @Override
    public void successOperationLog(String module, String operationType, String description, Throwable throwable) {
        this.commonLog(module, operationType, "SUCCESS", description, throwable);
    }

    @Override
    public void successOperationLog(String module, String operationType, String description) {
        this.commonLog(module, operationType, "SUCCESS", description, null);
    }

    @Override
    public void successOperationLog(String module, String operationType, String description, Object ... objects) {
        if (objects == null) {
            this.commonLog(module, operationType, "SUCCESS", description, null);
            return;
        }
        OperationLog operationLog = LogUtils.getOperationLog(objects);
        Throwable throwable = LogUtils.getThrowable(objects);
        this.commonLog(throwable, operationType, operationLog);
        this.addOperationLog(operationLog);
    }

    @Override
    public void errorLog(Logger logger, String message, Throwable throwable) {
        LoggerUtils.errorLog((Logger)logger, (String)message, (Throwable)throwable);
    }

    @Override
    public void errorLog(Logger logger, String message) {
        this.errorLog(logger, message, (Throwable)null);
    }

    @Override
    public void errorLog(Logger logger, String msg, Object ... objects) {
        LoggerUtils.errorLog((Logger)logger, (String)msg, (Object[])objects);
    }

    @Override
    public void errorLog(Logger logger, String msg, Throwable throwable, Object ... objects) {
        LoggerUtils.errorLog((Logger)logger, (String)msg, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void warnLog(Logger logger, String message, Throwable throwable) {
        LoggerUtils.warnLog((Logger)logger, (String)message, (Throwable)throwable);
    }

    @Override
    public void warnLog(Logger logger, String message) {
        LoggerUtils.warnLog((Logger)logger, (String)message, (Throwable)null);
    }

    @Override
    public void warnLog(Logger logger, String msg, Object ... objects) {
        LoggerUtils.warnLog((Logger)logger, (String)msg, (Object[])objects);
    }

    @Override
    public void warnLog(Logger logger, String msg, Throwable throwable, Object ... objects) {
        LoggerUtils.warnLog((Logger)logger, (String)msg, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void infoLog(Logger logger, String message, Throwable throwable) {
        LoggerUtils.infoLog((Logger)logger, (String)message, (Throwable)throwable);
    }

    @Override
    public void infoLog(Logger logger, String message) {
        LoggerUtils.infoLog((Logger)logger, (String)message, (Throwable)null);
    }

    @Override
    public void infoLog(Logger logger, String msg, Object ... objects) {
        LoggerUtils.infoLog((Logger)logger, (String)msg, (Object[])objects);
    }

    @Override
    public void infoLog(Logger logger, String msg, Throwable throwable, Object ... objects) {
        LoggerUtils.infoLog((Logger)logger, (String)msg, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void debugLog(Logger logger, String message, Throwable throwable) {
        LoggerUtils.debugLog((Logger)logger, (String)message, (Throwable)throwable);
    }

    @Override
    public void debugLog(Logger logger, String message) {
        LoggerUtils.debugLog((Logger)logger, (String)message, (Throwable)null);
    }

    @Override
    public void debugLog(Logger logger, String msg, Object ... objects) {
        LoggerUtils.debugLog((Logger)logger, (String)msg, (Object[])objects);
    }

    @Override
    public void debugLog(Logger logger, String msg, Throwable throwable, Object ... objects) {
        LoggerUtils.debugLog((Logger)logger, (String)msg, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void errorLog(CommonLogger commonLogger, String message, Throwable throwable) {
        LoggerUtils.errorLog((Logger)commonLogger.getLogger(), (String)message, (Throwable)throwable);
    }

    @Override
    public void errorLog(CommonLogger commonLogger, String message) {
        LoggerUtils.errorLog((Logger)commonLogger.getLogger(), (String)message, (Throwable)null);
    }

    @Override
    public void errorLog(CommonLogger commonLogger, String message, Object ... objects) {
        LoggerUtils.errorLog((Logger)commonLogger.getLogger(), (String)message, (Object[])objects);
    }

    @Override
    public void errorLog(CommonLogger commonLogger, String message, Throwable throwable, Object ... objects) {
        LoggerUtils.errorLog((Logger)commonLogger.getLogger(), (String)message, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void warnLog(CommonLogger commonLogger, String message, Throwable throwable) {
        LoggerUtils.warnLog((Logger)commonLogger.getLogger(), (String)message, (Throwable)throwable);
    }

    @Override
    public void warnLog(CommonLogger commonLogger, String message) {
        LoggerUtils.warnLog((Logger)commonLogger.getLogger(), (String)message, (Throwable)null);
    }

    @Override
    public void warnLog(CommonLogger commonLogger, String message, Object ... objects) {
        LoggerUtils.warnLog((Logger)commonLogger.getLogger(), (String)message, (Object[])objects);
    }

    @Override
    public void warnLog(CommonLogger commonLogger, String message, Throwable throwable, Object ... objects) {
        LoggerUtils.warnLog((Logger)commonLogger.getLogger(), (String)message, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void infoLog(CommonLogger commonLogger, String message, Throwable throwable) {
        LoggerUtils.infoLog((Logger)commonLogger.getLogger(), (String)message, (Throwable)throwable);
    }

    @Override
    public void infoLog(CommonLogger commonLogger, String message) {
        LoggerUtils.infoLog((Logger)commonLogger.getLogger(), (String)message, (Throwable)null);
    }

    @Override
    public void infoLog(CommonLogger commonLogger, String message, Object ... objects) {
        LoggerUtils.infoLog((Logger)commonLogger.getLogger(), (String)message, (Object[])objects);
    }

    @Override
    public void infoLog(CommonLogger commonLogger, String message, Throwable throwable, Object ... objects) {
        LoggerUtils.infoLog((Logger)commonLogger.getLogger(), (String)message, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void debugLog(CommonLogger commonLogger, String message, Throwable throwable) {
        LoggerUtils.debugLog((Logger)commonLogger.getLogger(), (String)message, (Throwable)throwable);
    }

    @Override
    public void debugLog(CommonLogger commonLogger, String message) {
        LoggerUtils.debugLog((Logger)commonLogger.getLogger(), (String)message, (Throwable)null);
    }

    @Override
    public void debugLog(CommonLogger commonLogger, String message, Object ... objects) {
        LoggerUtils.debugLog((Logger)commonLogger.getLogger(), (String)message, (Object[])objects);
    }

    @Override
    public void debugLog(CommonLogger commonLogger, String message, Throwable throwable, Object ... objects) {
        LoggerUtils.debugLog((Logger)commonLogger.getLogger(), (String)message, (Throwable)throwable, (Object[])objects);
    }

    private void commonLog(String module, String operationType, String status, String description, Throwable throwable) {
        if (StringUtils.isAnyBlank(module, description)) {
            LoggerUtils.errorLog((Logger)LOGGER, (String)"Illegal parameter", (Object[])new Object[0]);
            return;
        }
        String methodName = MethodStackUtils.getAnyClassMethodName(4);
        int lineNumber = MethodStackUtils.getAnyMethodLineNumber(4);
        LoggerUtils.infoLog((Logger)LOGGER, (String)MessageFormat.format("[Operation log][line:{0}] [OperationType:{1}] [{2}] module: {3} methodName: {4} description: {5}", lineNumber, operationType, status, module, methodName, description), (Throwable)throwable);
    }

    private void commonLog(Throwable throwable, String operationType, OperationLog operationLog) {
        if (operationLog == null) {
            LoggerUtils.errorLog((Logger)LOGGER, (String)"Illegal parameter", (Object[])new Object[0]);
            return;
        }
        LoggerUtils.infoLog((Logger)LOGGER, (String)this.getMessage(operationType, operationLog), (Throwable)throwable);
    }

    private String getMessage(String operationType, OperationLog operationLog) {
        String methodName = MethodStackUtils.getAnyClassMethodName(4);
        int lineNumber = MethodStackUtils.getAnyMethodLineNumber(4);
        String clientIp = operationLog.getClientIp();
        String moduleId = operationLog.getModuleId();
        String moduleType = operationLog.getModuleType();
        String operation = operationLog.getOperation();
        String operationParam = operationLog.getOperationParam();
        String oldParam = operationLog.getOldParam();
        String operationTime = operationLog.getOperationTime();
        String operator2 = operationLog.getOperator();
        String format = "[Operation log][%s %s %s][IP:%s,moduleType:%s,moduleId:%s,operationType:%s,operationParam:%s,oldParam:%s,methodName:%s,lineNumber:%s]";
        return String.format(Locale.ROOT, format, operationTime, operator2, operation, clientIp, moduleType, moduleId, operationType, operationParam, oldParam, methodName, lineNumber);
    }

    private Boolean addOperationLog(OperationLog operationLog) {
        OperationLogService operationLogService = (OperationLogService)SysconfigSpringContextHelper.getBean(OperationLogService.class);
        if (operationLogService == null) {
            LoggerUtils.errorLog((Logger)LOGGER, (String)"operationLogService of bean is empty", (Object[])new Object[0]);
            return false;
        }
        Boolean isAdd = false;
        try {
            OperationLogUtils.addOperationLog(operationLog);
            isAdd = operationLogService.addLog(operationLog);
            if (isAdd.booleanValue()) {
                LoggerUtils.infoLog((Logger)LOGGER, (String)"add operationLog success.", (Object[])new Object[0]);
            } else {
                LoggerUtils.infoLog((Logger)LOGGER, (String)"add operationLog failed.", (Object[])new Object[0]);
            }
        }
        catch (ServiceException e) {
            LoggerUtils.errorLog((Logger)LOGGER, (String)"operationLogService addLog exception", (Throwable)e);
        }
        return isAdd;
    }
}

