/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.log.web.impl;

import com.huawei.support.cbb.util.security.LoggerUtils;
import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import com.huawei.support.icscbb.log.common.util.LogUtils;
import com.huawei.support.icscbb.log.common.util.MethodStackUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.web.dto.SecurityLogDto;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityLogUtilsImpl
implements SecurityLogUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityLogUtilsImpl.class);

    @Override
    public void securityLog(String module, String description, Throwable throwable) {
        this.commonLog(module, description, throwable);
    }

    @Override
    public void securityLog(String module, String description) {
        this.commonLog(module, description, null);
    }

    @Override
    public void securityLog(String module, String description, Object ... objects) {
        if (objects == null) {
            this.commonLog(module, description, null);
            return;
        }
        SecurityLogDto securityLogDto = LogUtils.getSecurityLogDto(objects);
        Throwable throwable = LogUtils.getThrowable(objects);
        this.commonLog(throwable, securityLogDto);
    }

    @Override
    public void errorLog(Logger logger, String message, Throwable throwable) {
        LoggerUtils.errorLog((Logger)logger, (String)message, (Throwable)throwable);
    }

    @Override
    public void errorLog(Logger logger, String message) {
        LoggerUtils.errorLog((Logger)logger, (String)message, (Throwable)null);
    }

    @Override
    public void errorLog(Logger logger, String errorMessage, Object ... objects) {
        LoggerUtils.errorLog((Logger)logger, (String)errorMessage, (Object[])objects);
    }

    @Override
    public void errorLog(Logger logger, String errorMessage, Throwable throwable, Object ... objects) {
        LoggerUtils.errorLog((Logger)logger, (String)errorMessage, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void warnLog(Logger logger, String message, Throwable throwable) {
        LoggerUtils.warnLog((Logger)logger, (String)message, (Throwable)throwable);
    }

    @Override
    public void warnLog(Logger logger, String message) {
        LoggerUtils.warnLog((Logger)logger, (String)message, (Throwable)null);
    }

    @Override
    public void warnLog(Logger logger, String warnMessage, Object ... objects) {
        LoggerUtils.warnLog((Logger)logger, (String)warnMessage, (Object[])objects);
    }

    @Override
    public void warnLog(Logger logger, String warnMessage, Throwable throwable, Object ... objects) {
        LoggerUtils.warnLog((Logger)logger, (String)warnMessage, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void infoLog(Logger logger, String message, Throwable throwable) {
        LoggerUtils.infoLog((Logger)logger, (String)message, (Throwable)throwable);
    }

    @Override
    public void infoLog(Logger logger, String message) {
        LoggerUtils.infoLog((Logger)logger, (String)message, (Throwable)null);
    }

    @Override
    public void infoLog(Logger logger, String infoMessage, Object ... objects) {
        LoggerUtils.infoLog((Logger)logger, (String)infoMessage, (Object[])objects);
    }

    @Override
    public void infoLog(Logger logger, String infoMessage, Throwable throwable, Object ... objects) {
        LoggerUtils.infoLog((Logger)logger, (String)infoMessage, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void debugLog(Logger logger, String message, Throwable throwable) {
        LoggerUtils.debugLog((Logger)logger, (String)message, (Throwable)throwable);
    }

    @Override
    public void debugLog(Logger logger, String message) {
        LoggerUtils.debugLog((Logger)logger, (String)message, (Throwable)null);
    }

    @Override
    public void debugLog(Logger logger, String debugMessage, Object ... objects) {
        LoggerUtils.debugLog((Logger)logger, (String)debugMessage, (Object[])objects);
    }

    @Override
    public void debugLog(Logger logger, String debugMessage, Throwable throwable, Object ... objects) {
        LoggerUtils.debugLog((Logger)logger, (String)debugMessage, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void errorLog(CommonLogger commonLogger, String gsm, Throwable throwable) {
        LoggerUtils.errorLog((Logger)commonLogger.getLogger(), (String)gsm, (Throwable)throwable);
    }

    @Override
    public void errorLog(CommonLogger commonLogger, String gsm) {
        LoggerUtils.errorLog((Logger)commonLogger.getLogger(), (String)gsm, (Throwable)null);
    }

    @Override
    public void errorLog(CommonLogger commonLogger, String gsm, Object ... objects) {
        LoggerUtils.errorLog((Logger)commonLogger.getLogger(), (String)gsm, (Object[])objects);
    }

    @Override
    public void errorLog(CommonLogger commonLogger, String gsm, Throwable throwable, Object ... objects) {
        LoggerUtils.errorLog((Logger)commonLogger.getLogger(), (String)gsm, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void warnLog(CommonLogger commonLogger, String gsm, Throwable throwable) {
        LoggerUtils.warnLog((Logger)commonLogger.getLogger(), (String)gsm, (Throwable)throwable);
    }

    @Override
    public void warnLog(CommonLogger commonLogger, String gsm) {
        LoggerUtils.warnLog((Logger)commonLogger.getLogger(), (String)gsm, (Throwable)null);
    }

    @Override
    public void warnLog(CommonLogger commonLogger, String gsm, Object ... objects) {
        LoggerUtils.warnLog((Logger)commonLogger.getLogger(), (String)gsm, (Object[])objects);
    }

    @Override
    public void warnLog(CommonLogger commonLogger, String gsm, Throwable throwable, Object ... objects) {
        LoggerUtils.warnLog((Logger)commonLogger.getLogger(), (String)gsm, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void infoLog(CommonLogger commonLogger, String gsm, Throwable throwable) {
        LoggerUtils.infoLog((Logger)commonLogger.getLogger(), (String)gsm, (Throwable)throwable);
    }

    @Override
    public void infoLog(CommonLogger commonLogger, String gsm) {
        LoggerUtils.infoLog((Logger)commonLogger.getLogger(), (String)gsm, (Throwable)null);
    }

    @Override
    public void infoLog(CommonLogger commonLogger, String gsm, Object ... objects) {
        LoggerUtils.infoLog((Logger)commonLogger.getLogger(), (String)gsm, (Object[])objects);
    }

    @Override
    public void infoLog(CommonLogger commonLogger, String gsm, Throwable throwable, Object ... objects) {
        LoggerUtils.infoLog((Logger)commonLogger.getLogger(), (String)gsm, (Throwable)throwable, (Object[])objects);
    }

    @Override
    public void debugLog(CommonLogger commonLogger, String gsm, Throwable throwable) {
        LoggerUtils.debugLog((Logger)commonLogger.getLogger(), (String)gsm, (Throwable)throwable);
    }

    @Override
    public void debugLog(CommonLogger commonLogger, String gsm) {
        LoggerUtils.debugLog((Logger)commonLogger.getLogger(), (String)gsm, (Throwable)null);
    }

    @Override
    public void debugLog(CommonLogger commonLogger, String gsm, Object ... objects) {
        LoggerUtils.debugLog((Logger)commonLogger.getLogger(), (String)gsm, (Object[])objects);
    }

    @Override
    public void debugLog(CommonLogger commonLogger, String gsm, Throwable throwable, Object ... objects) {
        LoggerUtils.debugLog((Logger)commonLogger.getLogger(), (String)MessageFormat.format(gsm, objects), (Throwable)throwable);
    }

    private void commonLog(String module, String description, Throwable throwable) {
        if (StringUtils.isAnyBlank(module, description)) {
            this.errorLog(LOGGER, "Illegal parameter");
            return;
        }
        String methodName = MethodStackUtils.getAnyClassMethodName(4);
        int lineNumber = MethodStackUtils.getAnyMethodLineNumber(4);
        this.infoLog(LOGGER, "[Security log][line:" + lineNumber + "] module: " + module + " methodName: " + methodName + " description: " + description, throwable);
    }

    private void commonLog(Throwable throwable, SecurityLogDto securityLogDto) {
        if (securityLogDto == null) {
            this.errorLog(LOGGER, "Illegal parameter");
            return;
        }
        this.infoLog(LOGGER, this.getMessage(securityLogDto), throwable);
    }

    private String getMessage(SecurityLogDto securityLogDto) {
        String methodName = MethodStackUtils.getAnyClassMethodName(4);
        int lineNumber = MethodStackUtils.getAnyMethodLineNumber(4);
        String event = securityLogDto.getEvent();
        String appId = securityLogDto.getAppId();
        String moduleName = securityLogDto.getModuleName();
        String subtype = securityLogDto.getSubtype();
        String parameter = securityLogDto.getParameter();
        String format = "[Security log][%s][methodName:%s,lineNumber:%s,appId:%s,moduleName:%s,subtype:%s,parameter:%s]";
        return String.format(Locale.ROOT, format, event, methodName, lineNumber, appId, moduleName, subtype, parameter);
    }
}

