/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.cbb.util.interceptor;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.cbb.util.XssEncodeUtil;
import com.huawei.support.icscbb.util.json.JsonUtils;
import com.huawei.wsf.core.HWEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ui.ModelMap;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class SecurityInterceptorUtils
implements HandlerInterceptor {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(SecurityInterceptorUtils.class);
    private static final int MAP_DEFAULT_SIZE = 32;
    private static final List<Pattern> EXCLUSION_PATTERNS = new ArrayList<Pattern>();
    private List<String> inclusionClass;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.encodeModelMapForHtml(modelAndView);
        this.encodeReqAttrForHtml(request);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
    }

    private void encodeModelMapForHtml(ModelAndView modelAndView) {
        if (modelAndView == null) {
            return;
        }
        ModelMap modelMap = modelAndView.getModelMap();
        if (MapUtils.isEmpty(modelMap)) {
            return;
        }
        for (Map.Entry entry : modelMap.entrySet()) {
            Object modelValue;
            String modelKey = (String)entry.getKey();
            if (SecurityInterceptorUtils.isExcludeAttr(modelKey) || (modelValue = entry.getValue()) == null) continue;
            if (modelValue instanceof String) {
                modelMap.addAttribute(modelKey, HWEncoder.encodeForHTML((String)entry.getValue()));
                continue;
            }
            if (this.inclusionClass == null) continue;
            this.encodeModelMapObjectForHtml(modelMap, modelKey, modelValue);
        }
    }

    private void encodeReqAttrForHtml(HttpServletRequest request) {
        Enumeration enumerationReq = request.getAttributeNames();
        if (enumerationReq == null) {
            return;
        }
        HashMap<String, Object> attrKeys = new HashMap<String, Object>(32);
        while (enumerationReq.hasMoreElements()) {
            Object reqAttrValue;
            String reqAttrKey = (String)enumerationReq.nextElement();
            if (SecurityInterceptorUtils.isExcludeAttr(reqAttrKey) || (reqAttrValue = request.getAttribute(reqAttrKey)) == null) continue;
            attrKeys.put(reqAttrKey, reqAttrValue);
        }
        if (MapUtils.isEmpty(attrKeys)) {
            return;
        }
        for (Map.Entry entry : attrKeys.entrySet()) {
            Object reqAttrValue = entry.getValue();
            if (reqAttrValue instanceof String) {
                request.setAttribute((String)entry.getKey(), (Object)HWEncoder.encodeForHTML((String)reqAttrValue));
                continue;
            }
            if (this.inclusionClass == null) continue;
            this.encodeReqAttrObjectForHtml(request, (String)entry.getKey(), reqAttrValue);
        }
    }

    private static boolean isExcludeAttr(String modelKey) {
        for (Pattern pattern : EXCLUSION_PATTERNS) {
            if (!pattern.matcher(modelKey).matches()) continue;
            return true;
        }
        return false;
    }

    public void setInclusionClass(List<String> inclusionClass) {
        this.inclusionClass = inclusionClass;
    }

    public void setExclusionKeys(List<String> exclusionKeys) {
        if (exclusionKeys != null) {
            for (String key : exclusionKeys) {
                EXCLUSION_PATTERNS.add(Pattern.compile(key));
            }
        }
    }

    private Object encodeObjectForHtml(Object value) {
        Object result = new Object();
        try {
            String valueStr = XssEncodeUtil.encodeJsonForHtml(JsonUtils.objectToString(value));
            result = JsonUtils.stringToBean(valueStr, value.getClass());
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "encodeObjectForHTML error!", (Throwable)e);
        }
        return result;
    }

    private List<Object> encodeListForHtml(List<Object> valueList) {
        String valueClassName = "";
        for (Object object : valueList) {
            if (object == null) continue;
            valueClassName = object.getClass().getName();
            break;
        }
        if (StringUtils.isBlank(valueClassName)) {
            return valueList;
        }
        if (StringUtils.equals("java.lang.String", valueClassName)) {
            for (int i = 0; i < valueList.size(); ++i) {
                valueList.set(i, HWEncoder.encodeForHTML((String)valueList.get(i)));
            }
            return valueList;
        }
        for (String className : this.inclusionClass) {
            if (!StringUtils.equals(className, valueClassName)) continue;
            for (int i = 0; i < valueList.size(); ++i) {
                valueList.set(i, this.encodeObjectForHtml(valueList.get(i)));
            }
        }
        return valueList;
    }

    private Set<Object> encodeSetForHtml(Set<Object> valueSet) {
        String valueClassName = "";
        for (Object object : valueSet) {
            if (object == null) continue;
            valueClassName = object.getClass().getName();
            break;
        }
        if (StringUtils.isBlank(valueClassName)) {
            return valueSet;
        }
        HashSet<Object> newValueSet = new HashSet<Object>();
        if (StringUtils.equals("java.lang.String", valueClassName)) {
            for (Object modelSetValue : valueSet) {
                newValueSet.add(HWEncoder.encodeForHTML((String)modelSetValue));
            }
            return newValueSet;
        }
        for (String className : this.inclusionClass) {
            if (!StringUtils.equals(className, valueClassName)) continue;
            for (Object valueObject : valueSet) {
                newValueSet.add(this.encodeObjectForHtml(valueObject));
            }
        }
        return newValueSet;
    }

    private void encodeModelMapObjectForHtml(ModelMap modelMap, String modelKey, Object modelValue) {
        if (modelValue instanceof ArrayList) {
            List<Object> modelValueList = this.encodeListForHtml((List)modelValue);
            modelMap.addAttribute(modelKey, modelValueList);
            return;
        }
        if (modelValue instanceof Set) {
            Set<Object> newModelValueSet = this.encodeSetForHtml((Set)modelValue);
            modelMap.addAttribute(modelKey, newModelValueSet);
            return;
        }
        for (String className : this.inclusionClass) {
            if (!StringUtils.equals(className, modelValue.getClass().getName())) continue;
            modelMap.addAttribute(modelKey, this.encodeObjectForHtml(modelValue));
            break;
        }
    }

    private void encodeReqAttrObjectForHtml(HttpServletRequest request, String reqAttrKey, Object reqAttrValue) {
        if (reqAttrValue instanceof ArrayList) {
            List<Object> reqAttrValueList = this.encodeListForHtml((List)reqAttrValue);
            request.setAttribute(reqAttrKey, reqAttrValueList);
            return;
        }
        if (reqAttrValue instanceof Set) {
            Set<Object> newReqAttrValueSet = this.encodeSetForHtml((Set)reqAttrValue);
            request.setAttribute(reqAttrKey, newReqAttrValueSet);
            return;
        }
        for (String className : this.inclusionClass) {
            if (!StringUtils.equals(className, reqAttrValue.getClass().getName())) continue;
            request.setAttribute(reqAttrKey, this.encodeObjectForHtml(reqAttrValue));
            break;
        }
    }

    static {
        EXCLUSION_PATTERNS.add(Pattern.compile("org.springframework.*"));
        EXCLUSION_PATTERNS.add(Pattern.compile("com.opensymphony.*"));
        EXCLUSION_PATTERNS.add(Pattern.compile("CharacterEncodingFilter.FILTERED"));
        EXCLUSION_PATTERNS.add(Pattern.compile("websitePrefix"));
        EXCLUSION_PATTERNS.add(Pattern.compile("headerContent"));
        EXCLUSION_PATTERNS.add(Pattern.compile("footerContent"));
        EXCLUSION_PATTERNS.add(Pattern.compile("sessionId"));
        EXCLUSION_PATTERNS.add(Pattern.compile("contextPath"));
        EXCLUSION_PATTERNS.add(Pattern.compile("USER_INFO"));
        EXCLUSION_PATTERNS.add(Pattern.compile("WW_TRANS_I18N_LOCALE"));
        EXCLUSION_PATTERNS.add(Pattern.compile("_SESSION_USER_INFO"));
    }
}

