/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.http;

import com.alibaba.fastjson.JSONObject;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.UrlParamUtils;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class OkHttpClientUtils {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(OkHttpClientUtils.class);
    private static final int BYTE_LENGTH = 4096;
    private static final int EOF = -1;
    private static final int TOTAL_PROCESS = 100;

    private OkHttpClientUtils() {
    }

    public static String obtainGetMethodResult(HttpClientDto httpClientDto) {
        Request.Builder builder;
        OkHttpClient httpClient = httpClientDto.getHttpClient();
        if (httpClient == null) {
            return "";
        }
        String url = httpClientDto.getUrl();
        if (StringUtils.isBlank(url)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "obtainGetMethodResult, url is null.");
            return "";
        }
        try {
            builder = new Request.Builder().url(url);
        }
        catch (IllegalArgumentException exception) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The get http request url is Illegal.");
            return "";
        }
        Map<String, String> mapHeaders = httpClientDto.getHeaders();
        if (MapUtils.isNotEmpty(mapHeaders)) {
            Headers headers = OkHttpClientUtils.generateHeaders(mapHeaders);
            builder.headers(headers);
        }
        Request request = builder.build();
        return OkHttpClientUtils.getResult(request, httpClient);
    }

    public static String obtainPostMethodResult(HttpClientDto httpClientDto) {
        Request.Builder builder;
        OkHttpClient httpClient = httpClientDto.getHttpClient();
        if (httpClient == null) {
            return "";
        }
        String url = httpClientDto.getUrl();
        String mediaType = httpClientDto.getMediaType();
        if (StringUtils.isAnyBlank(url, mediaType)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "obtainPostMethodResult, url or mediaType is null.");
            return "";
        }
        try {
            builder = new Request.Builder().url(url);
        }
        catch (IllegalArgumentException exception) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The post http request url is Illegal.");
            return "";
        }
        Map<String, String> mapHeaders = httpClientDto.getHeaders();
        if (MapUtils.isNotEmpty(mapHeaders)) {
            Headers headers = OkHttpClientUtils.generateHeaders(mapHeaders);
            builder.headers(headers);
        }
        RequestBody body = OkHttpClientUtils.getRequestBody(url, mediaType, httpClientDto.getParams());
        Request request = builder.post(body).build();
        return OkHttpClientUtils.getResult(request, httpClient);
    }

    private static String getResult(Request request, OkHttpClient okHttpClient) {
        String result = "";
        try (Response execute = okHttpClient.newCall(request).execute();){
            ResponseBody responseBody;
            if (execute.isSuccessful() && (responseBody = execute.body()) != null) {
                result = responseBody.string();
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Http client is Illegal.", (Throwable)e);
        }
        return result;
    }

    private static RequestBody getRequestBody(String url, String mediaType, Map<String, String> params) {
        Map<Object, Object> requestBodys = new HashMap<String, String>();
        if (StringUtils.isNotBlank(url) && url.contains("?")) {
            UrlParamUtils.UrlDto urlDto = UrlParamUtils.parse(url);
            requestBodys = urlDto.getParams();
        }
        if (MapUtils.isEmpty(requestBodys)) {
            requestBodys = new HashMap();
        }
        if (MapUtils.isNotEmpty(params)) {
            requestBodys.putAll(params);
        }
        JSONObject paramObj = new JSONObject();
        Set<Map.Entry<Object, Object>> keySet = requestBodys.entrySet();
        for (Map.Entry<Object, Object> entry : keySet) {
            paramObj.put((String)entry.getKey(), entry.getValue());
        }
        String param = paramObj.toJSONString();
        return RequestBody.Companion.create(param, MediaType.parse((String)mediaType));
    }

    private static Headers generateHeaders(Map<String, String> headersParams) {
        Headers.Builder headersBuilder = new Headers.Builder();
        if (MapUtils.isNotEmpty(headersParams)) {
            Iterator<Map.Entry<String, String>> iterator = headersParams.entrySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().getKey();
                String value = iterator.next().getValue();
                headersBuilder.add(key, value);
            }
        }
        return headersBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean download(HttpClientDto httpClientDto, String saveDir, DownloadListener listener, String fileName) {
        OkHttpClient httpClient = httpClientDto.getHttpClient();
        if (httpClient == null) {
            return Boolean.FALSE;
        }
        Request.Builder builder = new Request.Builder().url(httpClientDto.getUrl());
        Map<String, String> mapHeaders = httpClientDto.getHeaders();
        if (MapUtils.isNotEmpty(mapHeaders)) {
            Headers headers = OkHttpClientUtils.generateHeaders(mapHeaders);
            builder.headers(headers);
        }
        Request request = builder.build();
        try (Response response = httpClient.newCall(request).execute();){
            if (OkHttpClientUtils.downloadProcess(saveDir, listener, fileName, response)) return Boolean.TRUE;
            boolean bl = Boolean.FALSE;
            return bl;
        }
        catch (IOException e) {
            listener.downloadFailed();
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "IOException", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    private static boolean downloadProcess(String saveDir, DownloadListener listener, String fileName, Response response) {
        String savePath;
        byte[] bytes = new byte[4096];
        try {
            savePath = OkHttpClientUtils.getDownloadSaveDir(saveDir);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, e.getMessage());
            listener.downloadFailed();
            return Boolean.FALSE;
        }
        ResponseBody body = response.body();
        File file = FileUtils.getFile(savePath, fileName);
        try (InputStream inputStream = body.byteStream();
             FileOutputStream fileOutputStream = FileUtils.openOutputStream(file);){
            long total = body.contentLength();
            long sum = 0L;
            int len = inputStream.read(bytes);
            while (len != -1) {
                fileOutputStream.write(bytes, 0, len);
                int progress = OkHttpClientUtils.getProcess(sum += (long)len, total);
                listener.downloading(progress);
                len = inputStream.read(bytes);
            }
            fileOutputStream.flush();
            listener.downloadSuccess();
        }
        catch (IOException e) {
            listener.downloadFailed();
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static int getProcess(long sum, long total) {
        if (total == 0L) {
            return 0;
        }
        return BigDecimal.valueOf(sum).divide(BigDecimal.valueOf(total), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).intValue();
    }

    private static String getDownloadSaveDir(String saveDir) throws IOException {
        File downloadFile = FileUtils.getFile(saveDir);
        if (!downloadFile.exists() && !downloadFile.mkdirs()) {
            throw new IOException("Create new directory failed.");
        }
        return downloadFile.getCanonicalPath();
    }

    public static interface DownloadListener {
        public void downloadSuccess();

        public void downloading(int var1);

        public void downloadFailed();
    }
}

