/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.http.dto;

import java.util.Map;
import okhttp3.Callback;
import okhttp3.OkHttpClient;

public class HttpClientDto {
    private OkHttpClient httpClient;
    private String url;
    private String mediaType;
    private String proxyPort;
    private String proxyHost;
    private String proxyUserName;
    private String proxyPassword;
    private long startPos;
    private long endPos;
    private Callback callback;
    private Map<String, String> params;
    private Map<String, String> headers;
    private String body;

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public long getStartPos() {
        return this.startPos;
    }

    public long getEndPos() {
        return this.endPos;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getBody() {
        return this.body;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private OkHttpClient httpClient;
        private String url;
        private String mediaType;
        private String proxyPort;
        private String proxyHost;
        private String proxyUserName;
        private String proxyPassword;
        private long startPos;
        private long endPos;
        private Callback callback;
        private Map<String, String> params;
        private Map<String, String> headers;
        private String body;

        public Builder() {
        }

        public Builder(HttpClientDto httpClientDto) {
            this.httpClient = httpClientDto.httpClient;
            this.url = httpClientDto.url;
            this.mediaType = httpClientDto.mediaType;
            this.proxyPort = httpClientDto.proxyPort;
            this.proxyHost = httpClientDto.proxyHost;
            this.proxyUserName = httpClientDto.proxyUserName;
            this.proxyPassword = httpClientDto.proxyPassword;
            this.startPos = httpClientDto.startPos;
            this.endPos = httpClientDto.endPos;
            this.callback = httpClientDto.callback;
            this.params = httpClientDto.params;
            this.headers = httpClientDto.headers;
            this.body = httpClientDto.body;
        }

        public Builder httpClient(OkHttpClient client) {
            this.httpClient = client;
            return this;
        }

        public Builder url(String requestUrl) {
            this.url = requestUrl;
            return this;
        }

        public Builder mediaType(String type) {
            this.mediaType = type;
            return this;
        }

        public Builder proxyPort(String port) {
            this.proxyPort = port;
            return this;
        }

        public Builder proxyHost(String host) {
            this.proxyHost = host;
            return this;
        }

        public Builder proxyUserName(String userName) {
            this.proxyUserName = userName;
            return this;
        }

        public Builder proxyPassword(String password) {
            this.proxyPassword = password;
            return this;
        }

        public Builder startPos(long requestStartPos) {
            this.startPos = requestStartPos;
            return this;
        }

        public Builder endPos(long requestEndPos) {
            this.endPos = requestEndPos;
            return this;
        }

        public Builder callback(Callback responseCallback) {
            this.callback = responseCallback;
            return this;
        }

        public Builder params(Map<String, String> requestParams) {
            this.params = requestParams;
            return this;
        }

        public Builder headers(Map<String, String> requestHeaders) {
            this.headers = requestHeaders;
            return this;
        }

        public Builder body(String requestBody) {
            this.body = requestBody;
            return this;
        }

        public HttpClientDto build() {
            HttpClientDto httpClientDto = new HttpClientDto();
            httpClientDto.httpClient = this.httpClient;
            httpClientDto.url = this.url;
            httpClientDto.mediaType = this.mediaType;
            httpClientDto.proxyPort = this.proxyPort;
            httpClientDto.proxyHost = this.proxyHost;
            httpClientDto.proxyUserName = this.proxyUserName;
            httpClientDto.proxyPassword = this.proxyPassword;
            httpClientDto.startPos = this.startPos;
            httpClientDto.endPos = this.endPos;
            httpClientDto.callback = this.callback;
            httpClientDto.params = this.params;
            httpClientDto.headers = this.headers;
            httpClientDto.body = this.body;
            return httpClientDto;
        }
    }
}

