/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.pool;

import com.google.common.cache.Cache;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.cache.CacheUtils;
import com.huawei.support.icscbb.util.constant.CommonConstants;
import java.lang.ref.SoftReference;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;

public class JdkZipFilePoolUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(JdkZipFilePoolUtils.class);

    private JdkZipFilePoolUtils() {
    }

    private static Cache<String, SoftReference<ZipFile>> getInstance() {
        return JdkZipFilePoolCacheHolder.INSTANCE;
    }

    public static ZipFile getZipFile(String key) {
        ZipFile zipFile = null;
        if (StringUtils.isBlank(key)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "zipFile key is empty");
            return zipFile;
        }
        SoftReference softReferenceZipFile = (SoftReference)JdkZipFilePoolUtils.getInstance().getIfPresent((Object)key);
        if (softReferenceZipFile == null) {
            CodeCCUtils.INSTANCE.warnLog(LOG, "no data in zipFile pool! key: {0}", key);
            return zipFile;
        }
        return (ZipFile)softReferenceZipFile.get();
    }

    public static void putZipFileToPool(String key, ZipFile zipFile) {
        if (StringUtils.isBlank(key) || zipFile == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Illegal parameter");
            return;
        }
        JdkZipFilePoolUtils.getInstance().put((Object)key, new SoftReference<ZipFile>(zipFile));
    }

    private static class JdkZipFilePoolCacheHolder {
        private static final Cache<String, SoftReference<ZipFile>> INSTANCE = CacheUtils.newCacheInstance(60, CommonConstants.POOL_RETAIN_TIME_UNIT, 50);

        private JdkZipFilePoolCacheHolder() {
        }
    }
}

