/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.pool;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.libentity.dto.LibEntityDo;
import com.huawei.support.icscbb.util.pool.BasePool;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;

public abstract class LibEntityPool<T extends LibEntityDo>
extends BasePool<T> {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(LibEntityPool.class);
    private static final int MAX_NUM = 9999;
    private static final int ONE_THOUSAND = 1000;
    private static final int ONE_HUNDRED = 100;
    private static final int MIN_NUM = 10;

    public String createId() throws NoSuchAlgorithmException {
        CodeCCUtils.INSTANCE.infoLog(LOG, "createId");
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        int docidint = sr.nextInt(9999);
        String docidSubffix = docidint / 1000 % 10 + "" + docidint / 100 % 10 + "" + docidint / 10 % 10 + "" + docidint % 10;
        return System.currentTimeMillis() + docidSubffix;
    }

    @Override
    public List<T> getAllPool(int start, int len) {
        ArrayList<LibEntityDo> pool = new ArrayList<LibEntityDo>();
        int time = 0;
        for (LibEntityDo t : this.objectMap.values()) {
            if (!t.isbUse()) continue;
            if (time >= start && time < start + len) {
                pool.add(t);
            }
            if (++time < start + len) continue;
            break;
        }
        return pool;
    }

    @Override
    public int poolSize() {
        int time = 0;
        for (LibEntityDo t : this.objectMap.values()) {
            if (!t.isbUse()) continue;
            ++time;
        }
        return time;
    }

    public int poolOldSize() {
        return super.poolSize();
    }

    public List<T> getAllOldPool(int start, int len) {
        return super.getAllPool(start, len);
    }
}

