/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.util.sys;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.util.HttpUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import com.huawei.wsf.core.HWEncoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.codecs.WindowsCodec;

public class SystemCommandUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(SystemCommandUtils.class);
    private static final int SUCCESS_EXIT = 0;
    private static final int FAIL_EXIT = 1;

    private SystemCommandUtils() {
    }

    public static String cmdExec(String cmdStr) {
        if (StringUtils.isBlank(cmdStr)) {
            return "";
        }
        String filterString = SystemCommandUtils.filterCmdInput(cmdStr);
        filterString = filterString.replaceAll("\\^", "");
        Runtime run = Runtime.getRuntime();
        try {
            Process process = run.exec(filterString);
            List<String> resultList = SystemCommandUtils.getStreamMessageList(process.getInputStream());
            List<String> errorList = SystemCommandUtils.getStreamMessageList(process.getErrorStream());
            int returnState = process.waitFor();
            if (CollectionUtils.isNotEmpty(resultList)) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "Process already start. msg:{0}", resultList);
            }
            if (CollectionUtils.isNotEmpty(errorList)) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Process error. msg:{0}", errorList);
            }
            if (returnState != 0) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "The cmd process abnormal end. state is: {0}", returnState);
                return "";
            }
            resultList.removeIf(String::isEmpty);
            return String.join((CharSequence)System.lineSeparator(), resultList);
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Exec cmd occur InterruptedException error. ", (Throwable)e);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Exec cmd occur io error. ", (Throwable)e);
        }
        return "";
    }

    public static String startProcess(Class klass, String javaHome, String processName, List<String> args, List<String> excludePath) throws IOException, InterruptedException {
        int returnState;
        String errMsg;
        ProcessBuilder builder = new ProcessBuilder(SystemCommandUtils.getProcessArgs(klass, javaHome, processName, args, excludePath));
        Process process = builder.start();
        String message = SystemCommandUtils.getStreamMessage(process.getInputStream());
        if (StringUtils.isNotBlank(message)) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Process already start. msg:{0}", message);
        }
        if (StringUtils.isNotBlank(errMsg = SystemCommandUtils.getStreamMessage(process.getErrorStream()))) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Process error. msg:{0}", errMsg);
        }
        if ((returnState = SystemCommandUtils.waitFor(process)) != 0) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The cmd process exception end. param maybe invalid.");
        }
        return message;
    }

    public static Process exec(List<String> commands, Map<String, String> environments) {
        Process process = null;
        if (CollectionUtils.isEmpty(commands)) {
            return process;
        }
        try {
            String errMsg;
            String inputMsg;
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            String[] command = commands.toArray(new String[0]);
            processBuilder.command(command);
            if (MapUtils.isNotEmpty(environments)) {
                Map<String, String> env = processBuilder.environment();
                env.putAll(environments);
            }
            if (StringUtils.isNotBlank(inputMsg = SystemCommandUtils.getStreamMessage((process = processBuilder.start()).getInputStream()))) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "Process already start. msg:{0}", inputMsg);
            }
            if (StringUtils.isNotBlank(errMsg = SystemCommandUtils.getStreamMessage(process.getErrorStream()))) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Process error. msg:{0}", errMsg);
            }
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Process start error.", (Throwable)e);
        }
        return process;
    }

    public static String getCurrentClassPath(Class klass) {
        if (klass == null) {
            return "";
        }
        URL url = klass.getResource("/");
        if (url == null) {
            return "";
        }
        return HttpUtils.decode(url.getPath());
    }

    public static List<String> getProcessArgs(Class processMainClass, String javaHome, String processName, List<String> args, List<String> excludePath) {
        if (processMainClass == null) {
            return new ArrayList<String>();
        }
        String javaBin = javaHome + File.separator + "bin" + File.separator + processName;
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(javaBin);
        commands.add("-cp");
        commands.add(SystemCommandUtils.getClassPath(SystemCommandUtils.getCurrentClassPath(processMainClass), excludePath));
        commands.add(processMainClass.getName());
        if (CollectionUtils.isNotEmpty(args)) {
            commands.addAll(args);
        }
        return commands;
    }

    public static List<String> getProcessArgs(Class processMainClass, String javaExe, List<String> jvmOptions, List<String> args, List<String> excludePath) {
        if (processMainClass == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> processCommands = new ArrayList<String>();
        processCommands.add(javaExe);
        processCommands.addAll(jvmOptions);
        processCommands.add("-cp");
        processCommands.add(SystemCommandUtils.getClassPath(SystemCommandUtils.getCurrentClassPath(processMainClass), excludePath));
        processCommands.add(processMainClass.getName());
        if (CollectionUtils.isNotEmpty(args)) {
            processCommands.addAll(args);
        }
        return processCommands;
    }

    public static int waitFor(Process process) throws InterruptedException {
        String errMsg;
        String inputMsg = SystemCommandUtils.getStreamMessage(process.getInputStream());
        if (StringUtils.isNotBlank(inputMsg)) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Process already start. msg:{0}", inputMsg);
        }
        if (StringUtils.isNotBlank(errMsg = SystemCommandUtils.getStreamMessage(process.getErrorStream()))) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Process error. msg:{0}", errMsg);
        }
        return process.waitFor();
    }

    public static int waitFor(Process process, long timeout, TimeUnit unit) throws InterruptedException {
        String errMsg;
        String inputMsg = SystemCommandUtils.getStreamMessage(process.getInputStream());
        if (StringUtils.isNotBlank(inputMsg)) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Process already start. msg:{0}", inputMsg);
        }
        if (StringUtils.isNotBlank(errMsg = SystemCommandUtils.getStreamMessage(process.getErrorStream()))) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Process error. msg:{0}", errMsg);
        }
        return process.waitFor(timeout, unit) ? 0 : 1;
    }

    private static String getClassPath(String classPath, List<String> excludePath) {
        if (StringUtils.isBlank(classPath)) {
            return classPath;
        }
        if (excludePath == null) {
            excludePath = new ArrayList<String>();
        }
        String tempClassPath = classPath.replace("/classes/", "/lib/");
        Object[] fileList = FileUtils.getFile(tempClassPath).listFiles();
        if (ArrayUtils.isEmpty(fileList)) {
            return classPath;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object file : fileList) {
            String fileName = ((File)file).getName();
            boolean exist = false;
            for (String path : excludePath) {
                if (!StringUtils.startsWith(fileName, path)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            String canonicalPath = IcsFileUtils.getCanonicalPath((File)file);
            stringBuilder.append(canonicalPath + ";");
        }
        return stringBuilder.toString();
    }

    private static String getStreamMessage(InputStream inputStream) {
        List<String> messages = SystemCommandUtils.getStreamMessageList(inputStream);
        return String.join((CharSequence)"", messages);
    }

    private static List<String> getStreamMessageList(InputStream inputStream) {
        ArrayList<String> messages = new ArrayList<String>();
        ThreadPoolExecutor threadPoolExecutor = ThreadPoolFactory.getThreadPool("processThreadPool", 5, 600, 30, 10);
        threadPoolExecutor.execute(() -> SystemCommandUtils.getMessageRunnable(inputStream, messages));
        return messages;
    }

    private static void getMessageRunnable(InputStream inputStream, List<String> messages) {
        try (InputStreamReader reader = new InputStreamReader(inputStream, "GBK");
             BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                messages.add(StringUtils.trim(line));
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "[getMessageRunnable]stream init error.", (Throwable)e);
        }
    }

    private static String filterCmdInput(String cmdStr) {
        return HWEncoder.encodeForOS(new WindowsCodec(), cmdStr);
    }

    public static Process getProcess(List<String> commands) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(commands);
        return processBuilder.start();
    }

    public static List<String> getReturnList(Process process) {
        List<String> streamMessageList = SystemCommandUtils.getStreamMessageList(process.getInputStream());
        String errMsg = SystemCommandUtils.getStreamMessage(process.getErrorStream());
        if (StringUtils.isNotBlank(errMsg)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Process error. msg:{0}", errMsg);
        }
        return streamMessageList;
    }
}

