/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.common.resources.software.info;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.xml.dom.XmlDom4jUtils;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.resources.software.dto.SoftwareDto;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class SoftwareInfo {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(SoftwareInfo.class);

    private SoftwareInfo() {
    }

    public static SoftwareDto getSoftwareInfo(String appDir) {
        String filePath = appDir + CommonConstants.APP_UPGRADE_PATH;
        Document softwareInfoDoc = XmlDom4jUtils.getDocument(filePath);
        if (softwareInfoDoc == null) {
            SoftwareDto result = null;
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The software information entity is empty.");
            return result;
        }
        Element rootElement = softwareInfoDoc.getRootElement();
        List<Element> elements = rootElement.elements();
        SoftwareDto upgradeDto = new SoftwareDto();
        for (Element element : elements) {
            if (element == null) continue;
            upgradeDto.setSoftName(SoftwareInfo.getAttrValue(element, "name"));
            upgradeDto.setSoftVersion(SoftwareInfo.getAttrValue(element, "version"));
            upgradeDto.setPublishTime(SoftwareInfo.getAttrValue(element, "publishTime"));
            upgradeDto.setSoftDesc(SoftwareInfo.getAttrValue(element, "desc"));
            break;
        }
        return upgradeDto;
    }

    private static String getAttrValue(Element element, String attrName) {
        return StringUtils.defaultIfBlank(element.attributeValue(attrName), "");
    }
}

