/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.common.resources.utils;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.common.resources.messages.MessageWithLink;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import javax.swing.JOptionPane;

public class LiteCommonUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(LiteCommonUtils.class);
    private static final int NUM_NOT_EXISTS = -1;
    private static final String SYSTEM_DEFAULT_BROWSER_TIP_TITLE = "system.default.browser.tip.title";
    private static final String SYSTEM_DEFAULT_BROWSER_TIP_CONTENT = "system.default.browser.tip.content";
    private static final int BYTES_LENGTH = 4096;

    private LiteCommonUtils() {
    }

    public static void openHtml(String openUrl) {
        try {
            Desktop.getDesktop().browse(new URI(openUrl));
        }
        catch (IOException | URISyntaxException e) {
            JOptionPane.showMessageDialog(null, new MessageWithLink(I18nResources.INSTANCE.getValueByKey(SYSTEM_DEFAULT_BROWSER_TIP_CONTENT)), I18nResources.INSTANCE.getValueByKey(SYSTEM_DEFAULT_BROWSER_TIP_TITLE), 2);
            CodeCCUtils.INSTANCE.errorLog(LOG, "Open web request or html failed.", (Throwable)e);
        }
    }

    public static String fileUnitExchange(long size) {
        double tempSize = size;
        DecimalFormat decimalFormat = new DecimalFormat("#0.00");
        if (tempSize < 1024.0) {
            return decimalFormat.format(tempSize) + "B";
        }
        if ((tempSize /= 1024.0) < 1024.0) {
            return decimalFormat.format(tempSize) + "KB";
        }
        if ((tempSize /= 1024.0) < 1024.0) {
            return decimalFormat.format(tempSize) + "MB";
        }
        return decimalFormat.format(tempSize /= 1024.0) + "GB";
    }

    static class StreamGobbler
    extends Thread {
        InputStream inputStream;

        StreamGobbler(InputStream inputStream) {
            this.inputStream = inputStream;
            super.setName("StreamGobblerThread");
        }

        @Override
        public void run() {
            try {
                byte[] bytes = new byte[4096];
                StringBuilder builder = new StringBuilder();
                while (this.inputStream.read(bytes) != -1) {
                    builder.append(new String(bytes, StandardCharsets.UTF_8));
                }
                CodeCCUtils.INSTANCE.debugLog(LOG, builder.toString());
            }
            catch (IOException exception) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "Obtain data failed.", (Throwable)exception);
            }
        }
    }
}

