/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.common.utils;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.sys.SystemCommandUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WinRegistryUtil {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(WinRegistryUtil.class);
    private static final String DEFAULT_KEY_NAME = "(\u9ed8\u8ba4)";
    private static final String SPACE_STR = " ";
    private static final String QUERY_VALUE_CMD_STRS = "reg query %s";
    private static final String QUERY_DEFAULT_VALUE_CMD_STRS = "reg query %s /ve";
    private static final String MODIFY_VALUE_CMD_STRS = "reg add %s /v %s /t %s /d %s";
    private static final String MODIFY_DEFAULT_VALUE_CMD_STRS = "reg add %s /ve /t %s /d %s /f";
    private static final String DELETE_VALUE_CMD_STRS = "reg delete %s /v %s /f";
    private static final String DELETE_DEFAULT_VALUE_CMD_STRS = "reg delete %s /ve /f";
    private static final String DELETE_BRANCH_CMD_STRS = "reg delete %s /f";
    private static final String WIN_REGISTRY_UTIL = "WinRegistryUtil";
    private static final int PROCESS_TIMEOUT = 1;

    private WinRegistryUtil() {
    }

    public static String queryWinRegistryValueContent(String registryPath, String keyValueName, String valueType) {
        List<String> commandStrsToLists = WinRegistryUtil.getCommandStrsToLists(QUERY_VALUE_CMD_STRS, registryPath);
        List<String> cmdRetRunList = WinRegistryUtil.regCommandInDos(commandStrsToLists);
        return WinRegistryUtil.getRunValue(keyValueName, valueType, cmdRetRunList);
    }

    private static String getRunValue(String keyValueName, String valueType, List<String> cmdRetRunStr) {
        String retRunValue = "";
        if (CollectionUtils.isEmpty(cmdRetRunStr)) {
            return retRunValue;
        }
        for (String item : cmdRetRunStr) {
            if (!item.startsWith(keyValueName)) continue;
            retRunValue = item.substring(item.indexOf(valueType.toUpperCase(Locale.ENGLISH)) + valueType.length()).trim();
            break;
        }
        return retRunValue;
    }

    public static String queryDefaultWinRegistryValueContent(String registryPath, String valueType) {
        List<String> commandStrsToLists = WinRegistryUtil.getCommandStrsToLists(QUERY_DEFAULT_VALUE_CMD_STRS, registryPath);
        List<String> cmdRetRunStr = WinRegistryUtil.regCommandInDos(commandStrsToLists);
        return WinRegistryUtil.getDefaultRunValue(valueType, cmdRetRunStr);
    }

    private static String getDefaultRunValue(String valueType, List<String> cmdRetRunStr) {
        return WinRegistryUtil.getRunValue(DEFAULT_KEY_NAME, valueType, cmdRetRunStr);
    }

    public static void updateWinRegistry(String registryPath, String keyValueName, String valueType, String keyValueContent) {
        WinRegistryUtil.deleteWinRegistry(registryPath, keyValueName);
        WinRegistryUtil.modifyWinRegistry(registryPath, keyValueName, valueType, keyValueContent);
    }

    public static boolean modifyWinRegistry(String registryPath, String keyValueName, String valueType, String keyValueContent) {
        List<String> commandStrsToLists = WinRegistryUtil.getCommandStrsToLists(MODIFY_VALUE_CMD_STRS, registryPath, keyValueName, valueType, keyValueContent);
        List<String> returnList = WinRegistryUtil.regCommandInDos(commandStrsToLists);
        boolean isCheckCmdRunResult = WinRegistryUtil.checkCmdRunResult(returnList);
        if (isCheckCmdRunResult) {
            SecurityLogUtils.INSTANCE.securityLog(WIN_REGISTRY_UTIL, "Success to modifyWinRegistry keyValueName : {0} ", keyValueName);
        } else {
            SecurityLogUtils.INSTANCE.securityLog(WIN_REGISTRY_UTIL, "Failed to modifyWinRegistry keyValueName : {0}", keyValueName);
        }
        return isCheckCmdRunResult;
    }

    public static boolean modifyWinDefaultRegistry(String registryPath, String valueType, String keyValueContent) {
        List<String> commandStrsToLists = WinRegistryUtil.getCommandStrsToLists(MODIFY_DEFAULT_VALUE_CMD_STRS, registryPath, valueType, keyValueContent);
        List<String> returnList = WinRegistryUtil.regCommandInDos(commandStrsToLists);
        boolean isCheckCmdRunResult = WinRegistryUtil.checkCmdRunResult(returnList);
        if (isCheckCmdRunResult) {
            SecurityLogUtils.INSTANCE.securityLog(WIN_REGISTRY_UTIL, "Success to modifyWinDefaultRegistry registryPath : {0}", registryPath);
        } else {
            SecurityLogUtils.INSTANCE.securityLog(WIN_REGISTRY_UTIL, "Failed to modifyWinDefaultRegistry registryPath : {0}", registryPath);
        }
        return isCheckCmdRunResult;
    }

    private static boolean checkCmdRunResult(List<String> returnList) {
        return StringUtils.containsAny((CharSequence)returnList.toString(), "\u6210\u529f", "success");
    }

    public static boolean deleteWinRegistry(String registryPath, String keyValueName) {
        List<String> commandStrsToLists = WinRegistryUtil.getCommandStrsToLists(DELETE_VALUE_CMD_STRS, registryPath, keyValueName);
        List<String> returnList = WinRegistryUtil.regCommandInDos(commandStrsToLists);
        boolean isCheckCmdRunResult = WinRegistryUtil.checkCmdRunResult(returnList);
        if (isCheckCmdRunResult) {
            SecurityLogUtils.INSTANCE.securityLog(WIN_REGISTRY_UTIL, "Success to deleteWinRegistry registryPath : {0}", registryPath);
        } else {
            SecurityLogUtils.INSTANCE.securityLog(WIN_REGISTRY_UTIL, "Failed to deleteWinRegistry registryPath : {0}", registryPath);
        }
        return isCheckCmdRunResult;
    }

    public static boolean deleteWinRegistry(String registryPath) {
        List<String> commandStrsToLists = WinRegistryUtil.getCommandStrsToLists(DELETE_DEFAULT_VALUE_CMD_STRS, registryPath);
        List<String> returnList = WinRegistryUtil.regCommandInDos(commandStrsToLists);
        boolean isCheckCmdRunResult = WinRegistryUtil.checkCmdRunResult(returnList);
        if (isCheckCmdRunResult) {
            SecurityLogUtils.INSTANCE.securityLog(WIN_REGISTRY_UTIL, "Success to deleteDefaultWinRegistry registryPath : {0}", registryPath);
        } else {
            SecurityLogUtils.INSTANCE.securityLog(WIN_REGISTRY_UTIL, "Failed to deleteDefaultWinRegistry registryPath : {0}", registryPath);
        }
        return isCheckCmdRunResult;
    }

    public static boolean deleteBranch(String registryPath) {
        List<String> commandStrsToLists = WinRegistryUtil.getCommandStrsToLists(DELETE_BRANCH_CMD_STRS, registryPath);
        List<String> returnList = WinRegistryUtil.regCommandInDos(commandStrsToLists);
        boolean isCheckCmdRunResult = WinRegistryUtil.checkCmdRunResult(returnList);
        if (isCheckCmdRunResult) {
            SecurityLogUtils.INSTANCE.securityLog(WIN_REGISTRY_UTIL, "Success to deleteBranch\uff0c registryPath: {0}", registryPath);
        } else {
            SecurityLogUtils.INSTANCE.securityLog(WIN_REGISTRY_UTIL, "Failed to deleteBranch\uff0cMaybe not exist, registryPath: {0}", registryPath);
        }
        return isCheckCmdRunResult;
    }

    private static List<String> regCommandInDos(List<String> commands) {
        ArrayList<String> resStringList = new ArrayList();
        try {
            Process process = SystemCommandUtils.getProcess(commands);
            resStringList = SystemCommandUtils.getReturnList(process);
            if (!process.waitFor(1L, TimeUnit.SECONDS)) {
                process.destroyForcibly();
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Registry Tool Process timeout, destroyForcibly.");
            }
        }
        catch (IOException | InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Failed to execute the command.", (Throwable)e);
        }
        return resStringList;
    }

    private static List<String> getCommandStrsToLists(String commandStrs, String ... params) {
        ArrayList<String> commandLists = new ArrayList<String>();
        if (StringUtils.isBlank(commandStrs)) {
            return commandLists;
        }
        String[] commandArrays = commandStrs.split(SPACE_STR);
        int paramsIndex = 0;
        for (String command : commandArrays) {
            if (StringUtils.equals(command, "%s")) {
                commandLists.add("\"" + params[paramsIndex] + "\"");
                ++paramsIndex;
                continue;
            }
            commandLists.add(command);
        }
        return commandLists;
    }
}

