/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.tray;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.common.resources.utils.LiteCommonUtils;
import com.huawei.support.icslite.tray.IcsMenuHandler;
import com.huawei.support.icslite.tray.component.IcsLiteTray;
import com.huawei.wsf.core.HWEncoder;
import java.awt.AWTException;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.errors.EncodingException;

public class IcsLiteMainFrame
extends JFrame {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsLiteMainFrame.class);
    private static final int MOUSE_EVENT_DOUBLE_CLICK = 2;
    private static final String ICS_LITE_TRAY_TITLE = "ICS Lite";
    private static final String DOULE_CLICK_SPECIAL_CHAR = "?";
    private static final String DOULE_CLICK_SPECIAL_CHAR_ENCODE = "%C2%A0";
    private static final String DOULE_CLICK_NEED_REPLACE_CHAR = "%3F";
    private static final long serialVersionUID = 5863630698515854762L;
    private static URL picPath;
    private static boolean isAutoStart;
    private static boolean isDlStart;
    private static boolean isDoubleClickStart;
    private static String doubleClickLibPath;

    public static void setIsAutoStart(boolean isAuto) {
        isAutoStart = isAuto;
    }

    public static void setIsDoubleClickStart(boolean isDoubleClickStart) {
        IcsLiteMainFrame.isDoubleClickStart = isDoubleClickStart;
    }

    public static void setDoubleClickLibPath(String doubleClickLibPath) {
        IcsLiteMainFrame.doubleClickLibPath = doubleClickLibPath;
    }

    public static void setIsDlStart(boolean isDlStart) {
        IcsLiteMainFrame.isDlStart = isDlStart;
    }

    public static void systemTray() {
        if (!SystemTray.isSupported()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The system tray is not supported in the current system.");
            return;
        }
        ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(picPath));
        IcsLiteTray trayIcon = new IcsLiteTray(icon.getImage(), ICS_LITE_TRAY_TITLE);
        SystemTray sysTray = SystemTray.getSystemTray();
        trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    IcsLiteMainFrame.openIcsLiteHomepage();
                }
            }
        });
        try {
            sysTray.add(trayIcon);
        }
        catch (AWTException ex) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "AWTException error", (Throwable)ex);
        }
        trayIcon.setImageAutoSize(true);
        if (IcsLiteMainFrame.isOpenHomepage()) {
            IcsLiteMainFrame.openIcsLiteHomepage();
        }
        if (isDoubleClickStart) {
            IcsLiteMainFrame.openIcsLiteDoubleClickBrowsePage();
        }
    }

    private static void openIcsLiteHomepage() {
        LiteCommonUtils.openHtml(IcsMenuHandler.getInstance().getHomePage());
    }

    private static void openIcsLiteDoubleClickBrowsePage() {
        String doubleClickBrowseUrl = IcsMenuHandler.getInstance().getDoubleClickBrowsePage() + IcsLiteMainFrame.doubleClickUrlEncode();
        CodeCCUtils.INSTANCE.infoLog(LOG, "start open doubleClickLib doubleClickLibPath: {0}", doubleClickBrowseUrl);
        LiteCommonUtils.openHtml(doubleClickBrowseUrl);
    }

    private static String doubleClickUrlEncode() {
        String encodeUrl = "";
        try {
            encodeUrl = HWEncoder.encodeForURL(doubleClickLibPath);
            if (StringUtils.containsNone((CharSequence)doubleClickLibPath, DOULE_CLICK_SPECIAL_CHAR)) {
                return encodeUrl;
            }
        }
        catch (EncodingException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "doubleClickUrlEncode EncodingException");
        }
        return StringUtils.replace(encodeUrl, DOULE_CLICK_NEED_REPLACE_CHAR, DOULE_CLICK_SPECIAL_CHAR_ENCODE);
    }

    private static boolean isOpenHomepage() {
        return !isAutoStart && !isDoubleClickStart && !isDlStart;
    }

    static {
        isAutoStart = false;
        isDlStart = false;
        isDoubleClickStart = false;
        ClassLoader classLoader = IcsLiteMainFrame.class.getClassLoader();
        picPath = classLoader.getResource("pic/tray_main.png");
    }
}

