/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.tray;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.sys.SystemCommandUtils;
import com.huawei.support.icslite.common.constant.CommonConstants;
import com.huawei.support.icslite.common.constant.RegistryConstants;
import com.huawei.support.icslite.common.resources.utils.CmdCharacterUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.common.utils.WinRegistryUtil;
import com.huawei.support.icslite.config.init.ConfigInitHandler;
import com.huawei.support.icslite.config.migration.ConfigMigrationBroker;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.support.icslite.tray.ExitHandler;
import com.huawei.support.icslite.tray.IcsLiteMainFrame;
import com.huawei.support.icslite.tray.IcsMenuHandler;
import com.huawei.support.icslite.tray.predetection.DetectionHandler;
import com.huawei.support.icslite.tray.server.TomcatUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public class IcsLiteSplash
extends JWindow {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsLiteSplash.class);
    private static final int ACCESS_TOMCAT_THREADS = 2;
    private static final String REGIST_DOUBLE_CLICK_RYPARAM_KEY = "libpath";
    private static final String REGIST_AUTO_START_RYPARAM_KEY = "launchparam";
    private static final int TOMCAT_INIT_ACCESS = 1;
    private static final int TOMCAT_MAX_ACCESS = 100;
    private static final int SPLASH_MAX_COUNT = 300;
    private static boolean isDoubleClickLibStart = false;
    private static String doubleClickLibPath;
    private static boolean isAutoStart;
    private final JProgressBar progress;
    private final transient ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(2, new BasicThreadFactory.Builder().namingPattern("Lite-Splash-Task-%d").build());

    public IcsLiteSplash() {
        CodeCCUtils.INSTANCE.infoLog(LOG, "Tray init icslite property start.");
        ConfigInitHandler.getInstance().init();
        ConfigMigrationBroker.getInstance().init();
        ConfigMigrationBroker.getInstance().execute();
        CodeCCUtils.INSTANCE.infoLog(LOG, "Tray init icslite property success.");
        String liteLanguage = ConfigServiceHandler.getInstance().get("system.lang");
        CodeCCUtils.INSTANCE.infoLog(LOG, "The icslite language is {0}, icslite version is {1}", liteLanguage, IcsCommonServiceHandler.getInstance().getAppVersion());
        I18nResources.INSTANCE.initResourceBundle(liteLanguage);
        Container container = this.getContentPane();
        this.setCursor(Cursor.getPredefinedCursor(3));
        URL url = this.getClass().getClassLoader().getResource("pic/tray_main.png");
        if (url != null) {
            container.add((Component)new JLabel(new ImageIcon(url)), "Center");
        }
        String splashTip = I18nResources.INSTANCE.getValueByKey("tray.splash.tip.content");
        this.progress = new JProgressBar(1, 100);
        this.progress.setStringPainted(true);
        this.progress.setString(splashTip);
        this.progress.setBackground(Color.white);
        container.add((Component)this.progress, "South");
        this.setAlwaysOnTop(true);
        Dimension screen = this.getToolkit().getScreenSize();
        this.pack();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
    }

    public static void main(String[] args) {
        String autoStartParam;
        OperationLogUtils.INSTANCE.successOperationLog("icsliteTray", "STARTUP", "user has startuped ics lite app,app will run later.");
        Map<String, String> registryParams = IcsLiteSplash.getRegistryParams(args);
        IcsLiteSplash.isDlStart(registryParams);
        String doubleClickParam = registryParams.get(REGIST_DOUBLE_CLICK_RYPARAM_KEY);
        if (StringUtils.isNotBlank(doubleClickParam)) {
            isDoubleClickLibStart = true;
            CodeCCUtils.INSTANCE.infoLog(LOG, "System isDoubleClickLibStart");
            doubleClickLibPath = doubleClickParam;
        }
        if (StringUtils.isNotBlank(autoStartParam = registryParams.get(REGIST_AUTO_START_RYPARAM_KEY))) {
            isAutoStart = StringUtils.equals("ICSLiteAutoStart", autoStartParam);
            CodeCCUtils.INSTANCE.infoLog(LOG, "System autoRun");
        }
        IcsLiteSplash.updateAutoRunPath();
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!StringUtils.equalsIgnoreCase("Windows", info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Select os ui failed", (Throwable)e);
        }
        if (IcsLiteSplash.checkUpgradeFile()) {
            IcsCommonServiceHandler.getInstance().startUpgrader();
            CodeCCUtils.INSTANCE.infoLog(LOG, "the UpgradeOperate.txt exists,excute upgrade operation");
            return;
        }
        IcsLiteSplash splash = new IcsLiteSplash();
        splash.start();
    }

    public static boolean checkUpgradeFile() {
        boolean isExist = false;
        String path = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "upgrade" + File.separator + "upgradeOperate.txt";
        File file = FileUtils.getFile(path);
        if (file.exists()) {
            isExist = true;
        }
        return isExist;
    }

    private static Map<String, String> getRegistryParams(String[] args) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        for (String arg : args) {
            if (StringUtils.isBlank(arg)) {
                return paramsMap;
            }
            int index = arg.indexOf("=");
            if (index >= arg.length() - 1) continue;
            String argName = arg.substring(0, index);
            String argValue = arg.substring(index + 1);
            paramsMap.put(argName, argValue);
        }
        return paramsMap;
    }

    private static void updateAutoRunPath() {
        String isAutoRun = WinRegistryUtil.queryWinRegistryValueContent(RegistryConstants.LITE_REGISTY_PATH, "IsAllowedAutoRun", "REG_SZ");
        if (StringUtils.equals(isAutoRun, "0")) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Auto start is off.");
            return;
        }
        String autoRunPath = CmdCharacterUtils.getAutoRunPath();
        String nowPath = WinRegistryUtil.queryWinRegistryValueContent(RegistryConstants.REGISTY_WINDOWS_RUN_PATH, "IcsLite", "REG_SZ");
        if (StringUtils.equals(nowPath, autoRunPath)) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "Auto start is open and run path is same.");
            return;
        }
        WinRegistryUtil.updateWinRegistry(RegistryConstants.REGISTY_WINDOWS_RUN_PATH, "IcsLite", "REG_SZ", autoRunPath);
        CodeCCUtils.INSTANCE.infoLog(LOG, "Auto run path is updated");
    }

    private static void isDlStart(Map<String, String> registryParams) {
        String autoStartParam = registryParams.get(REGIST_AUTO_START_RYPARAM_KEY);
        if (StringUtils.isNotBlank(autoStartParam)) {
            IcsLiteMainFrame.setIsDlStart(StringUtils.equals("ICSLiteDlStart", autoStartParam));
            CodeCCUtils.INSTANCE.infoLog(LOG, "Batch download startup.");
        }
    }

    public void start() {
        this.toFront();
        this.init();
    }

    private void init() {
        this.setVisible(!isAutoStart);
        this.deleteUpgraderJre();
        this.generateMarkFile();
        try {
            Callable<Boolean> myCallable = this::detectionAndStart;
            Future<Boolean> future = this.scheduledThreadPoolExecutor.submit(myCallable);
            this.traySplashProcess(future);
        }
        catch (InterruptedException | ExecutionException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The splash process exec interrupted.", (Throwable)e);
        }
        if (!isAutoStart) {
            this.dispose();
        }
        IcsLiteMainFrame.setIsAutoStart(isAutoStart);
        IcsLiteMainFrame.setIsDoubleClickStart(isDoubleClickLibStart);
        IcsLiteMainFrame.setDoubleClickLibPath(doubleClickLibPath);
        IcsLiteMainFrame.systemTray();
    }

    private Boolean detectionAndStart() throws InterruptedException {
        DetectionHandler detectionHandler = new DetectionHandler();
        detectionHandler.detectionEnv("beforeStartup");
        if (ExitHandler.isExit()) {
            TimeUnit.MILLISECONDS.sleep(200L);
        }
        if (SystemCommandUtils.exec(this.getProcessCommand(), this.getProcessEnv()) == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "ICS Lite tomcat startup fail!");
            return false;
        }
        if (this.isStartup()) {
            return true;
        }
        detectionHandler.detectionEnv("afterStartup");
        ExitHandler.exitApp();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void traySplashProcess(Future<Boolean> future) throws InterruptedException, ExecutionException {
        String splashTip = I18nResources.INSTANCE.getValueByKey("tray.splash.data_migration.tip.content");
        int progressValue = 0;
        int splashCount = 0;
        while (true) {
            TimeUnit.MILLISECONDS.sleep(500L);
            progressValue = this.getProgressValueAndShow(progressValue);
            if (!future.isDone() || !future.get().booleanValue()) continue;
            if (++splashCount > 300) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "traySplashProcess : splash screen more than SPLASH_MAX_COUNT");
                return;
            }
            if (this.isKmcmigrated(splashTip)) return;
        }
    }

    private int getProgressValueAndShow(int progressValue) {
        int progressValueTemp = progressValue;
        Dimension dimension = this.progress.getSize();
        Rectangle rect = new Rectangle(0, 0, dimension.width, dimension.height);
        this.progress.setValue(progressValueTemp += 10);
        if (progressValueTemp >= 100) {
            progressValueTemp = 0;
        }
        this.progress.paintImmediately(rect);
        return progressValueTemp;
    }

    private boolean isKmcmigrated(String splashTip) {
        if (StringUtils.equals("true", ConfigServiceHandler.getInstance().getFromFile("system.old.encryptData.migrated"))) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "traySplashProcess : KmcMigrationBroker.execute() completed");
            return true;
        }
        this.progress.setString(splashTip);
        return false;
    }

    private void generateMarkFile() {
        boolean isSuccess;
        String programDataPath = IcsCommonServiceHandler.getInstance().getSysProgramDataPath() + ConfigServiceHandler.getInstance().get("system.lang");
        File icsContentFile = FileUtils.getFile(programDataPath);
        if (!icsContentFile.exists() && !(isSuccess = icsContentFile.mkdirs())) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The system name obtain failed.");
            return;
        }
        this.createClientMark(programDataPath + CommonConstants.CLIENT_MARK);
    }

    private void createClientMark(String markPath) {
        File markFile = FileUtils.getFile(markPath);
        if (markFile.exists()) {
            int checkLineLength = this.checkLineLength(markFile);
            if (checkLineLength == 36) {
                CodeCCUtils.INSTANCE.warnLog(LOG, "MarkFile is exists clientId.");
                return;
            }
            if (!markFile.delete()) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "MarkFile delete fail.");
            }
        } else {
            this.createMarkFile(markFile);
        }
        String randomId = UUID.randomUUID().toString().replaceAll("-", "") + "Lite";
        if (StringUtils.isBlank(randomId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create clientMarkId fail.");
            return;
        }
        try (OutputStreamWriter fileWriter = new OutputStreamWriter(Files.newOutputStream(markFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            fileWriter.write(randomId);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "file Write failed.");
        }
    }

    private int checkLineLength(File markFile) {
        int length = 0;
        if (markFile.length() == 0L) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "The markFile does not contain any content.");
            return length;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(markFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            String buffer = bufferedReader.readLine();
            if (StringUtils.isNotBlank(buffer)) {
                length = buffer.length();
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "checkLineLength, io error.");
        }
        return length;
    }

    private void createMarkFile(File dirFile) {
        try {
            if (!dirFile.createNewFile()) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "File already exists.");
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "file Write failed.");
        }
    }

    private void deleteUpgraderJre() {
        IcsCommonServiceHandler.getInstance().exitUpgrader();
        String upgraderJrePath = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + "upgrader";
        File file = FileUtils.getFile(upgraderJrePath);
        try {
            IcsFileUtils.deleteFile(file);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "delete upgrader jre exception.");
        }
    }

    private List<String> getProcessCommand() {
        ArrayList<String> commend = new ArrayList<String>();
        commend.add(String.format(Locale.ENGLISH, "\"%s\\tomcat\\bin\\startup.bat\"", IcsCommonServiceHandler.getInstance().getAppRootDir()));
        return commend;
    }

    private Map<String, String> getProcessEnv() {
        HashMap<String, String> env = new HashMap<String, String>();
        String appRootDir = IcsCommonServiceHandler.getInstance().getAppRootDir();
        env.put("_RUNJAVA", "");
        env.put("_RUNJDB", "");
        env.put("CATALINA_LOGGING_CONFIG", "");
        env.put("CATALINA_HOME", appRootDir + File.separator + "tomcat");
        env.put("CATALINA_OPTS", " -Dorg.apache.catalina.connector.RECYCLE_FACADES=true");
        env.put("CATALINA_BASE", appRootDir + File.separator + "tomcat");
        env.put("JRE_HOME", appRootDir + File.separator + "jre");
        env.put("IcsLogDir", appRootDir);
        env.put("JAVA_OPTS", this.getJavaOpts(appRootDir));
        return env;
    }

    private String getJavaOpts(String appRootDir) {
        StringBuilder javaOpts = new StringBuilder();
        javaOpts.append(String.format(Locale.ENGLISH, " -Duser.language=%s -Djava.library.path=\"%s\\tomcat\\webapps\\icslite\\WEB-INF\\lib\\kmc\\lib\" -Djavax.net.ssl.trustStoreType=Windows-ROOT -Dfastjson.parser.safeMode=true", ConfigServiceHandler.getInstance().get("system.lang"), appRootDir));
        javaOpts.append(" -XX:MinHeapFreeRatio=10 -XX:MaxHeapFreeRatio=50 -Xss256k -XX:MetaspaceSize=64m -XX:MaxMetaspaceSize=128m -XX:MinMetaspaceFreeRatio=40 -XX:MaxMetaspaceFreeRatio=70 -XX:InitialCodeCacheSize=4m -XX:ReservedCodeCacheSize=64m -XX:+UseCodeCacheFlushing -XX:-TieredCompilation");
        javaOpts.append(" -XX:+UseConcMarkSweepGC -XX:+CMSParallelRemarkEnabled -XX:+ScavengeBeforeFullGC -XX:+CMSScavengeBeforeRemark -XX:+UseCMSCompactAtFullCollection");
        javaOpts.append(String.format(Locale.ENGLISH, " -XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=\"%s\\tomcat\\..\\applog\\tomcatLogs\\heapdump_%d.hprof\"", appRootDir, System.currentTimeMillis()));
        return javaOpts.toString();
    }

    private boolean isStartup() throws InterruptedException {
        String checkUrl = IcsMenuHandler.getInstance().getHttpInfo() + "/icslite/sys/message/check";
        CodeCCUtils.INSTANCE.infoLog(LOG, "GetTomcatCallable start checkUrl:{0}", checkUrl);
        for (int accessCount = 1; accessCount <= 100; ++accessCount) {
            boolean isOutput;
            int accessLogOutput = accessCount % 10;
            boolean bl = isOutput = accessLogOutput == 0;
            if (TomcatUtils.connectionCheckUrl(checkUrl)) {
                CodeCCUtils.INSTANCE.debugLog(LOG, "Exec result is true");
                return true;
            }
            if (accessCount == 100) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "The tomcat init request is exceed max count.");
                return false;
            }
            if (isOutput) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "The tomcat init request is failed, will have retry.");
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        return false;
    }

    static {
        isAutoStart = false;
    }
}

