/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.tray;

import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.common.utils.ValidateUtils;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.tray.TomcatXmlParser;

public class IcsMenuHandler {
    private String litePort;
    private String httpIp;

    private IcsMenuHandler() {
        this.initTrayMenu();
    }

    public static IcsMenuHandler getInstance() {
        return IcsMenuHandlerHolder.INSTANCE;
    }

    private void initTrayMenu() {
        this.litePort = String.valueOf(TomcatXmlParser.getHttpPort());
        this.httpIp = ConfigServiceHandler.getInstance().get("system.open.httpIpInfo");
        if (!ValidateUtils.validateIpAndPort(this.httpIp, this.litePort)) {
            IcsCommonServiceHandler.getInstance().exitApp();
        }
    }

    public String getHomePage() {
        return this.getHttpInfo() + "/icslite/" + "?t=" + System.currentTimeMillis();
    }

    public String getDoubleClickBrowsePage() {
        return this.getHttpInfo() + "/icslite/" + "doubleclick/anylocationlib?libpath=";
    }

    public String getHttpInfo() {
        return "http://" + this.httpIp + ":" + this.litePort;
    }

    public String getOfflineDownloadPage() {
        return this.getHttpInfo() + "/icslite/#hash=downloadmanage&download=offline";
    }

    public String getSettingPage() {
        return this.getHttpInfo() + "/icslite/sys/preferences?id=setting";
    }

    public String getAboutPage() {
        return this.getHttpInfo() + "/icslite/sys/preferences?id=about" + "&t=" + System.currentTimeMillis();
    }

    public String getUninstallPage() {
        return this.getHttpInfo() + "/icslite/sys/preferences?id=help" + "#faq";
    }

    public String getHelpPage() {
        return this.getHttpInfo() + "/icslite/sys/preferences?id=help";
    }

    public String getSoftMessagePage() {
        return this.getHttpInfo() + "/icslite/sys/preferences?id=message";
    }

    public String getSoftUpgradePage() {
        return this.getHttpInfo() + "/icslite/sys/preferences?id=upgrade";
    }

    private static class IcsMenuHandlerHolder {
        private static final IcsMenuHandler INSTANCE = new IcsMenuHandler();

        private IcsMenuHandlerHolder() {
        }
    }
}

