/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.tray;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.xml.dom.XmlDom4jUtils;
import com.huawei.support.icslite.tray.constant.IcsLiteFrameConstants;
import java.util.List;
import java.util.Optional;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class TomcatXmlParser {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(TomcatXmlParser.class);
    private static int httpPort;

    private TomcatXmlParser() {
    }

    private static void parsePort() {
        Document document = XmlDom4jUtils.getDocument(IcsLiteFrameConstants.SERVER_PATH);
        Optional<Attribute> portAttributeOpt = TomcatXmlParser.getPortAttr(document);
        if (portAttributeOpt.isPresent()) {
            httpPort = Integer.parseInt(portAttributeOpt.get().getValue());
        }
    }

    public static void updateLitePort(int portValue) {
        Document document = XmlDom4jUtils.getDocument(IcsLiteFrameConstants.SERVER_PATH);
        Optional<Attribute> attributeOpt = TomcatXmlParser.getPortAttr(document);
        if (!attributeOpt.isPresent()) {
            return;
        }
        httpPort = portValue;
        attributeOpt.get().setValue(String.valueOf(portValue));
        XmlDom4jUtils.writeXml(document, IcsLiteFrameConstants.SERVER_PATH);
    }

    private static Optional<Attribute> getPortAttr(Document document) {
        if (document == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "The Tomcat server xml document is not exist.");
            return Optional.empty();
        }
        Element rootElement = document.getRootElement();
        if (rootElement == null) {
            return Optional.empty();
        }
        List<Element> elements = rootElement.elements("Service");
        for (Element element : elements) {
            List<Element> connectors = element.elements("Connector");
            for (Element connector : connectors) {
                Attribute protocolAttribute = connector.attribute("protocol");
                if (protocolAttribute == null || !protocolAttribute.getValue().startsWith("HTTP")) continue;
                return Optional.ofNullable(connector.attribute("port"));
            }
        }
        return Optional.empty();
    }

    public static int getHttpPort() {
        return httpPort;
    }

    static {
        TomcatXmlParser.parsePort();
    }
}

